/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.InvokeValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.InfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class InvokeValidatorImpl extends ExchangeValidatorImpl<Invoke> implements InvokeValidator {

	private static Logger log = Logger.getLogger(InvokeValidatorImpl.class.getName());

	public InvokeValidatorImpl(final Invoke invoke) {
		super(invoke);
	}

	@Override
	public void validate() {
		super.validate();

		// validation
		log.finest("validate invoke: " + this.getActivity().getName());
		try {
			// unsupported element
			if((((TInvoke)((BPELElementImpl)this.getActivity()).getModel()).getFromParts() != null) && (((TInvoke)((BPELElementImpl)this.getActivity()).getModel()).getFromParts().getFromPart().size() > 0)) {
				StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.getActivity(), "In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but the fromPart activity is not supported by BPEL engine for the moment. Use assign element after this invoke instead"));
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but the fromPart activity is not supported by BPEL engine for the moment. Use assign element after this invoke instead")));
			}
			if((((TInvoke)((BPELElementImpl)this.getActivity()).getModel()).getToParts() != null) && (((TInvoke)((BPELElementImpl)this.getActivity()).getModel()).getToParts().getToPart().size() > 0)) {
				StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.getActivity(), "In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but the topart activity is not supported by BPEL engine for the moment. Use assign element before this invoke instead"));
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but the topart activity is not supported by BPEL engine for the moment. Use assign element before this invoke instead")));
			}
			if(((TInvoke)((BPELElementImpl)this.getActivity()).getModel()).getCompensationHandler() != null) {
				StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.getActivity(), "In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but compensationHandler is not supported by BPEL engine for the moment."));
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but compensationHandler is not supported by BPEL engine for the moment.")));
			}

			// validation if null or empty
			if((this.getActivity().getPartnerLink() == null) || (this.getActivity().getPartnerLink().trim().length() == 0)) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => the partnerLink cannot be null or empty")));
			}
			if((this.getActivity().getOperation() == null) || (this.getActivity().getOperation().trim().length() == 0)) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => the operation cannot be null or empty")));
			}
			if((this.getActivity().getInputVariable() == null) || (this.getActivity().getInputVariable().trim().length() == 0)) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => the input variable cannot be null or empty")));
			}
			if((this.getActivity().getOutputVariable() != null) && (this.getActivity().getInputVariable().trim().length() == 0)) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => the output variable cannot be empty")));
			}

			// validation if exist

			// find partnerLink
			if((this.getActivity().getPartnerLink() != null) && (this.getActivity().getPartnerLink().trim().length() > 0)) {
				final PartnerLink partnerLink = ScopeImpl.findPartnerLinkRecursively(this.getActivity().getPartnerLink(), (BPELElement) ((BPELElementImpl)this.getActivity()).getParent());
				if(partnerLink == null) {
					StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find partnerLink corresponding to the name: " + this.getActivity().getPartnerLink())));
				}

				// find operation
				if((this.getActivity().getOperation() != null) && (this.getActivity().getOperation().trim().length() > 0)) {
					if(partnerLink != null) {
						final BPELProcess process = ScopeImpl.getProcess((this.getActivity()));

						final List<AbsItfInterfaceType> itfsToVerify = new ArrayList<AbsItfInterfaceType>();
						if(this.getActivity().getInterface() != null) {
							final InterfaceType itf = process.getImports().getInterface(this.getActivity().getInterface());
							if(itf != null) {
								itfsToVerify.add(itf);
							}
						} else {
							final PartnerLinkType plt = process.getImports().getPartnerLinkType(partnerLink.getPartnerLinkType());
							if(plt == null) {
								StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In receive " + this.getActivity().getName() + " => Impossible to find partnerLink corresponding to the name: " + partnerLink.getPartnerLinkType())));
							}
							if(plt != null) {
								if(((partnerLink.getMyRole() == null) || (partnerLink.getMyRole().trim().length() == 0))&&
										((partnerLink.getPartnerRole() == null) || (partnerLink.getPartnerRole().trim().length() == 0))) {
									// get all role of partnerLink type
									for(final Role r: plt.getRoles()) {
										itfsToVerify.add(r.getInterface());
									}
								} else {
									if((partnerLink.getMyRole() != null) && (partnerLink.getMyRole().trim().length() > 0)) {
										for(final Role r: plt.getRoles()) {
											if(r.getName().equals(partnerLink.getMyRole())) {
												itfsToVerify.add(r.getInterface());
												break;
											}
										}
									} 
									if((partnerLink.getPartnerRole() != null) && (partnerLink.getPartnerRole().trim().length() > 0)) {
										for(final Role r: plt.getRoles()) {
											if(r.getName().equals(partnerLink.getPartnerRole())) {
												itfsToVerify.add(r.getInterface());
												break;
											}
										}
									}
								}
							}
						}
						final List<AbsItfOperation> ops = new ArrayList<AbsItfOperation>();
						if(itfsToVerify.size() == 0) {
							if(this.getActivity().getInterface() != null) {
								StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find in wsdl descriptions the portType: " + this.getActivity().getInterface())));
							} else {
								StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find portType. You must add portType attribute in invoke or add a role to the partnerLink of invoke")));
							}
						}

						for(final AbsItfInterfaceType itf: itfsToVerify) {
							final AbsItfOperation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), this.getActivity().getOperation()));
							if(op != null) {
								ops.add(op);
							}
						}

						if(ops.size() == 0) {
							StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find in wsdl descriptions the operation: " + this.getActivity().getOperation())));
						} else if(ops.size() > 1) {
							String itfString = null;
							for(final AbsItfOperation op: ops) {
								if(itfString == null) {
									itfString = ((AbsItfInterfaceType)((AbstractWSDLElementImpl)op).getParent()).getQName().toString();
								} else {
									itfString = itfString + ", " + ((AbsItfInterfaceType)((AbstractWSDLElementImpl)op).getParent()).getQName().toString();
								}
							}
							StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Several interfaces match with the operation " + this.getActivity().getOperation() + ": " + itfString + ". " +  "You must add portType attribute in invoke or add a role to the partnerLink of invoke")));
						}

					}



				}

			}

			// find variable
			if((this.getActivity().getInputVariable() != null) && (this.getActivity().getInputVariable().trim().length() > 0)) {
				final BPELVariable var = ScopeImpl.findVariableRecursively(new QName(this.getActivity().getInputVariable()), (BPELElement) ((BPELElementImpl)this.getActivity()).getParent());
				if(var == null) {
					StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find input variable corresponding to the name: " + this.getActivity().getInputVariable())));
				}
			}
			if((this.getActivity().getOutputVariable() != null) && (this.getActivity().getOutputVariable().trim().length() > 0)) {
				final BPELVariable var = ScopeImpl.findVariableRecursively(new QName(this.getActivity().getOutputVariable()), (BPELElement) ((BPELElementImpl)this.getActivity()).getParent());
				if(var == null) {
					StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find output variable corresponding to the name: " + this.getActivity().getOutputVariable())));
				}
			}
		} catch (final WSDL4BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => " + e.getMessage())));
		}
	}

}
