/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.List;

import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.VariableValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class VariableValidatorImpl implements VariableValidator {

	private BPELVariable var = null;

	public VariableValidatorImpl(final BPELVariable var) {
		this.var = var;
	}

	public void validate() {
		// validation

		// validation if null or empty
		if((this.var.getQName() == null) || (this.var.getQName().getLocalPart().trim().length() == 0)) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.var, new BPELException("In variable definition => Variable cannot be null or empty")));
		}
		
		// validation on content
		if(((this.var.getMessageType() == null) || (this.var.getMessageType().getLocalPart().trim().length() == 0)) &&
				((this.var.getElement() == null) || (this.var.getElement().getLocalPart().trim().length() == 0)) &&
				((this.var.getTypeQName() == null) || (this.var.getTypeQName().getLocalPart().trim().length() == 0))) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.var, new BPELException("In variable definition => You must define the variable. Please, Set this type using messageType, element, or type attribute")));
		}
		
		
		final BPELProcess process = ScopeImpl.getProcess(this.var);
		
		// find if message exist
		if(this.var.getMessageType() != null) {
			final MessageImpl msg = process.getImports().getMessage(this.var.getMessageType());
			if(msg == null) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.var, new BPELException("In variable definition => Impossible to find message \"" + this.var.getMessageType() +"\" of variable " + this.var.getQName())));
			}
		}
		
		// find if element exist
		if(this.var.getElement() != null) {
			final List<org.ow2.easywsdl.schema.api.Element> elmts = process.getImports().findElementsInAllSchema(this.var.getElement());
			if((elmts == null)||(elmts.size() == 0)) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.var, new BPELException("In variable definition => Impossible to find element \"" + this.var.getElement() +"\" of variable " + this.var.getQName())));
			}
		}
		
		// find if type exist
		if(this.var.getTypeQName() != null) {
			final Type type = SchemaFactory.getDefaultSchema().getType(this.var.getTypeQName());
			if(type == null) {
				final List<Type> types = process.getImports().findTypesInAllSchema(this.var.getTypeQName()); 
				if(types.size() == 0) {
					StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.var, new BPELException("In variable definition => Impossible to find type \"" + this.var.getElement() +"\" of variable " + this.var.getQName())));
				}
			}
		}
	}

}
