/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.correlation;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelationSets;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class CorrelationSetImpl extends BPELElementImpl<TCorrelationSet> implements CorrelationSet {


	

	private final TCorrelationSets correlationSets;



	public CorrelationSetImpl(final TCorrelationSet model, final TCorrelationSets correlationSets, final BPELElement parent) throws BPELException {
		super(Constants._CorrelationSet_QNAME, model, parent);
		this.correlationSets = correlationSets;
	}


	public String getName() {
		return this.model.getName();
	}


	public void setName(final String value) {
		this.model.setName(value);
	}

	public List<QName> getProperties() {
		return this.model.getProperties();
	}


	public static List<CorrelationSet> extractCorrelationSetsInModel(final TCorrelationSets correlationsets, final BPELElement parent) throws BPELException {
		final List<CorrelationSet> res = new ArrayList<CorrelationSet>(); 
		if(correlationsets != null) {
			if((correlationsets.getCorrelationSet() != null)&&
					(correlationsets.getCorrelationSet().size() > 0)) {
				for(final TCorrelationSet correlationset: correlationsets.getCorrelationSet()) {
					res.add(new CorrelationSetImpl(correlationset, correlationsets, parent));
				}
			}
		}
		return res;
	}
}
