/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Logger;

import org.jdom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.BPELBooleanExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ParseException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELBooleanExpressionImpl extends BPELExpressionImpl<Boolean> implements BPELBooleanExpression {


	private Logger log = Logger.getLogger(BPELBooleanExpressionImpl.class.getName());


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private BPELProcess bpeldefinition;

	public BPELBooleanExpressionImpl(final TExpression model, final BPELElement parent) {
		super(Constants._Condition_QNAME, model, parent);
		this.bpeldefinition = ScopeImpl.getProcess(parent);
	}

	public Boolean evaluate(final Scope scope) throws CoreException {
		Boolean res = null;
		String booleanExpression = "";
		if(this.getContent() != null) {
			booleanExpression = this.getContent();
		}
		try {
			this.log.finest("boolean expression to evaluate: " + booleanExpression);
			final InputStream input = new ByteArrayInputStream(booleanExpression.getBytes());
			final ExpressionAnalyzer analyzer = new ExpressionAnalyzer(input);
			final ASTStart n = analyzer.Start();
			final ExpressionVisitor v = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
			if(!this.log.getName().equals(BPELBooleanExpressionImpl.class.getName())) {
				((ExpressionDumpVisitor)v).setLog(this.log);
			}
			final Object result = n.jjtAccept(v, null);
			if(result instanceof BPELException) {
				throw (BPELException)result;
			} else if(result instanceof Element) {
				final Element elmt = (Element)result; 
				res = Boolean.parseBoolean(elmt.getText());
			} else {
				throw new BPELException("result unknown");
			}
		} catch (final BPELException e) {
			throw new CoreException("Impossible to evaluate expression: " + booleanExpression, e);
		} catch (final ParseException e) {
			throw new CoreException("Impossible to evaluate expression: " + booleanExpression, e);
		}
		return res;
	}

	public BPELProcess getBpeldefinition() {
		return this.bpeldefinition;
	}

	public void setBpeldefinition(final BPELProcess bpeldefinition) {
		this.bpeldefinition = bpeldefinition;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

	public Expression<String, Boolean> copypaste() {
		final BPELBooleanExpression exp = new BPELBooleanExpressionImpl(this.getModel(), (BPELElement) this.getParent());
		return exp;
	}

}
