/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.BPELElementExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ParseException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELElementExpressionImpl extends BPELExpressionImpl<Element> implements BPELElementExpression {

	
	private final Logger log = Logger.getLogger(BPELElementExpressionImpl.class.getName());

	
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	
	private final BPELProcess bpeldefinition;


	public BPELElementExpressionImpl(final QName name, final TExpression model, final BPELElement parent) {
		super(name, model, parent);
		this.bpeldefinition = ScopeImpl.getProcess(parent);
	}

	public Element evaluate(final Scope scope) throws CoreException {
		Element res = null;
		String elmtExpression = "";
		if(this.getContent() != null) {
			elmtExpression = this.getContent();
		}
		try {
			this.log.finest("element expression to evaluate: " + elmtExpression);
			final InputStream input = new ByteArrayInputStream(elmtExpression.getBytes());
			final ExpressionAnalyzer analyzer = new ExpressionAnalyzer(input);
			final ASTStart n = analyzer.Start();
			final ExpressionVisitor v = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
			if(!this.log.getName().equals(BPELElementExpressionImpl.class.getName())) {
				((ExpressionDumpVisitor)v).setLog(this.log);
			}
			final Object result = n.jjtAccept(v, null);
			if(result instanceof BPELException) {
				throw (BPELException)result;
			} else if(result instanceof org.jdom.Element) {
				res = (org.jdom.Element)result; 
			} else {
				throw new BPELException("result unknown");
			}
		} catch (final BPELException e) {
			throw new CoreException("Impossible to evaluate expression: " + elmtExpression, e);
		} catch (final ParseException e) {
			throw new CoreException("Impossible to evaluate expression: " + elmtExpression, e);
		}
		return res;
	}

	public Expression<String, Element> copypaste() {
		final BPELElementExpression exp = new BPELElementExpressionImpl(this.getTag(), this.getModel(), (BPELElement) this.getParent());
		return exp;
	}



}
