/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression.function;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.AbstractXPathFunction;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.CompareFunction;

/**
 * @author Julien Lesbegueries - eBM WebSourcing
 */
public class CompareFunctionImpl extends AbstractXPathFunction<Integer> implements CompareFunction {

	private static Logger log = Logger.getLogger(CompareFunctionImpl.class.getName());

	private final String comparand1;
	private final String comparand2;
	private final String collation;
	
	public CompareFunctionImpl(final String ns, final String par1, final String par2, final String par3) throws BPELException {
		super(ns);
		this.comparand1 = par1;
		this.comparand2 = par2;
		this.collation = par3;
	}

	public CompareFunctionImpl(final String ns, final String par1, final String par2) throws BPELException {
		super(ns);
		this.comparand1 = par1;
		this.comparand2 = par2;
		this.collation = null;
	}

	public Integer process() throws BPELException {

		if(this.collation == null){
			return Integer.signum((this.comparand1.compareTo(this.comparand2)));
		}else //3 parameters
		{
			//TODO Use collation to compare strings ...
			log.warning("collation "+this.collation+ "not yet supported.");
			return Integer.signum((this.comparand1.compareTo(this.comparand2)));
		}
	}



}
