/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression.function;

import java.util.Calendar;
import java.util.Date;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.AbstractXPathFunction;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.DateTimeFunction;


/**
 * @author alouis - eBM WebSourcing
 */
public class DateTimeFunctionImpl extends AbstractXPathFunction<Date> implements DateTimeFunction {

	private Date date = null;

	private Date time = null;

	public DateTimeFunctionImpl(final String ns, final Date date, final Date time) throws BPELException {
		super(ns);
		this.date = date;
		this.time = time;
	}

	public Date process() {
		final Calendar datetimeC = Calendar.getInstance();
		if(this.time != null) {
			datetimeC.setTime(this.time);
		}
		if(this.date != null) {
			final Calendar dateC = Calendar.getInstance();
			dateC.setTime(this.date);
			datetimeC.set(dateC.get(Calendar.YEAR), dateC.get(Calendar.MONTH), dateC.get(Calendar.DAY_OF_MONTH));
		}
		return datetimeC.getTime();
	}

}
