/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression.function;

import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.AbstractXPathFunction;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.SubstringAfterFunction;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 * @author alouis - eBM WebSourcing
 */
public class SubstringAfterFunctionImpl extends AbstractXPathFunction<String>  implements SubstringAfterFunction {

	private static Logger log = Logger
			.getLogger(SubstringAfterFunctionImpl.class.getName());

	private final List<String> params;

	public SubstringAfterFunctionImpl(final String ns, final List<String> params) throws BPELException {
		super(ns);
		this.params = params;
		log.finest("Parameters for function SubstringAfter : "+params.toString());
	}

	public String process() throws BPELException {
		String res = "";
		final String s = this.params.get(0);
		final int index = s.indexOf(this.params.get(1)) + 1;
		res = s.substring(index);
		log.finest("Result of function SubstringAfter : "+res);
		return res;
	}

}
