/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.inout;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;

import com.ebmwebsourcing.easybpel.model.bpel.XMLConstants;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELJAXBContext {

    /**
     * The JAXB context
     */
    private JAXBContext jaxbContext;
    
    private Schema schema;

	private final List<Class<?>> defaultObjectFactories = new ArrayList<Class<?>>(Arrays.asList(new Class<?>[] {
            com.ebmwebsourcing.easybpel.model.bpel.executable.ObjectFactory.class,
            com.ebmwebsourcing.easybpel.model.bpel.serviceref.ObjectFactory.class,
            com.ebmwebsourcing.easybpel.model.bpel._abstract.ObjectFactory.class,
            com.ebmwebsourcing.easybpel.model.bpel.varprop.ObjectFactory.class,
            org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.ObjectFactory.class,
            com.ebmwebsourcing.easybpel.model.bpel.extensionactivities.ObjectFactory.class}));

    /**
     * Private object initializations
     */
    public BPELJAXBContext() throws BPELException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

        
        final URL schemaUrlBpelExecutable = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_executable.xsd");
        final URL schemaUrlBpelServiceRef = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_serviceref.xsd");
        final URL schemaUrlBpel_abstract = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_abstract_common_base.xsd");
        final URL schemaUrlBpel_varprop = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_varprop.xsd");
        final URL schemaUrlBpelParnterLink = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_plnktype.xsd");
        final URL schemaUrlEbmExtensionActitivies = BPELJAXBContext.class.getResource("/" + "schema/bpel/extensionActivity/ExtensionActivities.xsd");

        try {
            this.schema = factory.newSchema(new StreamSource[] { 
            		new StreamSource(schemaUrlBpelExecutable.openStream()), 
            		new StreamSource(schemaUrlBpelServiceRef.openStream()), 
            		new StreamSource(schemaUrlBpel_abstract.openStream()), 
            		new StreamSource(schemaUrlBpel_varprop.openStream()),
            		new StreamSource(schemaUrlBpelParnterLink.openStream()),
            		new StreamSource(schemaUrlEbmExtensionActitivies.openStream())
            		});

           
            
            this.jaxbContext = JAXBContext.newInstance(this.defaultObjectFactories.toArray(new Class[this.defaultObjectFactories.size()]));
        } catch (final SAXException e) {
            throw new BPELException(e);
        } catch (final IOException e) {
            throw new BPELException(e);
        } catch (final JAXBException e) {
            throw new BPELException(e);
        }
    }


    /**
     * Private object initializations
     */
    public void addedObjectFactories(final List<Class<?>> addedObjectFactories) throws BPELException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

        final URL schemaUrlBpelExecutable = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_executable.xsd");
        final URL schemaUrlBpelServiceRef = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_serviceref.xsd");
        final URL schemaUrlBpel_abstract = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_abstract_common_base.xsd");
        final URL schemaUrlBpel_varprop = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_varprop.xsd");
        final URL schemaUrlBpelParnterLink = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_plnktype.xsd");
        final URL schemaUrlEbmExtensionActitivies = BPELJAXBContext.class.getResource("/" + "schema/bpel/extensionActivity/ExtensionActivities.xsd");

        final List<Class<?>> objectFactories = new ArrayList<Class<?>>();
        objectFactories.addAll(this.defaultObjectFactories);
        if(addedObjectFactories != null) {
            objectFactories.addAll(addedObjectFactories);
        }

        try {
        	this.schema = factory.newSchema(new StreamSource[] { 
            		new StreamSource(schemaUrlBpelExecutable.openStream()), 
            		new StreamSource(schemaUrlBpelServiceRef.openStream()), 
            		new StreamSource(schemaUrlBpel_abstract.openStream()), 
            		new StreamSource(schemaUrlBpel_varprop.openStream()),
            		new StreamSource(schemaUrlBpelParnterLink.openStream()),
            		new StreamSource(schemaUrlEbmExtensionActitivies.openStream())
            		});

            this.jaxbContext = JAXBContext.newInstance(objectFactories.toArray(new Class[objectFactories.size()]));

        } catch (final SAXException e) {
            throw new BPELException(e);
        } catch (final IOException e) {
            throw new BPELException(e);
        } catch (final JAXBException e) {
            throw new BPELException(e);
        }

    }

    /**
     * @return the jaxbContext
     */
    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }
    

    public Schema getSchema() {
		return this.schema;
	}
}
