/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.message;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.org.w3._2001.xmlschema.FormChoice;
import org.ow2.easywsdl.tooling.xsd2xml.XSD2XML;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.InternalMessageImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELInternalMessageImpl extends InternalMessageImpl<Element> implements
InternalMessage<Element>, BPELInternalMessage {


	@Override
	public String toString() {
		String res = null;
		if(this.getContent() != null) {
			final XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
			res = outputter.outputString(this.getContent());
		} else {
			res = super.toString();
		}

		return res; 
	}

	public static boolean createMessageIfNotExist(final Variable v, final Descriptions desc) throws BPELException {
		boolean res = false;
		final BPELVariable definition = (BPELVariable)v;
		if((v.getValue() == null)||((v.getValue() != null)&&(v.getValue().getContent() == null))) {
			final BPELInternalMessage message = BPELInternalMessageImpl.createMessage(definition, desc);

			v.setValue(message);

			// set default value if exist
			if(definition.getFrom() != null) {
				// create literal element
				final Element rightSide = new Element("literal");
				final Document doc = new Document(rightSide);
				if(definition.getFrom().getKind() == From.Kind.EXPRESSION) {
					final String value = definition.getFrom().getContent();
					rightSide.setText(value);
				} else if(definition.getFrom().getKind() == From.Kind.LITERAL) {
					// create literal element
					if(definition.getFrom().getLiteral().getElementContent() != null) {
						rightSide.addContent(definition.getFrom().getLiteral().getElementContent().detach());
					} else if(definition.getFrom().getLiteral().getStringContent() != null) {
						rightSide.setText(definition.getFrom().getLiteral().getStringContent());
					}
				} 
				// realize the affectation
				// 1 - Realize type verification
				//TODO: realize type verifcation

				// 2 - remove all child on left side
				((Element)v.getValue().getContent()).removeContent();
				((Element)v.getValue().getContent()).setText(null);

				// 3 - affect
				((Element)v.getValue().getContent()).setText(rightSide.getText());
			}
			res = true;
		}
		return res;
	}


	public static BPELInternalMessage createMessage(final BPELVariable definition, final Descriptions desc)
	throws BPELException {
		BPELInternalMessage message = null;
		try {
			// Message not exist => Create message
			message = new BPELInternalMessageImpl();


			if(definition.getMessageType() != null) {
				final MessageImpl msg = desc.getMessage(definition.getMessageType());

				if(msg == null) {
					throw new BPELException("Error: the message cannot be null: " + definition.getMessageType());
				}

				// create all part
				final List<Element> elmts = new ArrayList<Element>();
				for(final Part part: msg.getParts()) {

					// create part
					if(part.getElement() != null) {
						final org.ow2.easywsdl.schema.api.Element elmt = part.getElement();
						final Element content = XSD2XML.newInstance().generateElement(elmt,"?");
						elmts.add(content);
					} else if(part.getType() != null) {
						final org.ow2.easywsdl.schema.api.Element elmt = (org.ow2.easywsdl.schema.api.Element) ((AbstractSchemaElementImpl)part.getType()).getSchema().createElement();
						elmt.setQName(new QName(part.getPartQName().getLocalPart()));
						elmt.setType(part.getType());
						final Element content = XSD2XML.newInstance().generateElement(elmt,"?");
						content.setNamespace(null);
						elmts.add(content);
					}
				}

				final Element rootMessage = new Element(definition.getMessageType().getLocalPart());
				final Document doc = new Document(rootMessage);
				if(definition.getMessageType().getNamespaceURI() != null) {
					rootMessage.setNamespace(Namespace.getNamespace(definition.getMessageType().getPrefix(), definition.getMessageType().getNamespaceURI()));
				}

				// add all parts
				for(final Element elmt: elmts) {

					// test to avoid that a same prefix used by rootMessage and elmt have several namespaces
					if(((rootMessage.getNamespacePrefix() != null)&&(elmt.getNamespace(rootMessage.getNamespacePrefix()) != null))&&
							(!elmt.getNamespace(rootMessage.getNamespacePrefix()).getURI().equals(rootMessage.getNamespaceURI()))) {
						// change root prefix
						int i = 0;
						Namespace nsAlreadyUsed = elmt.getNamespace("cns" + i);
						while(nsAlreadyUsed != null) {
							i++;
							nsAlreadyUsed = elmt.getNamespace("cns" + i);
						}
						rootMessage.setNamespace(Namespace.getNamespace("cns" + i, rootMessage.getNamespaceURI()));
					}

					rootMessage.addContent(elmt.detach());
				}

				message.setContent(doc.getRootElement());

				// print msg
			} else if(definition.getTypeQName() != null) {

				// create local variable
				Type type = SchemaFactory.getDefaultSchema().getType(definition.getTypeQName());
				if(type == null) {
					final List<Type> types = desc.findTypesInAllSchema(definition.getTypeQName()); 
					if(types.size() == 0) {
						throw new BPELException("Impossible to find type \"" + definition.getTypeQName() + "\" in all schemas");
					}
					type = types.get(0);
				}

				if(type == null) {
					throw new BPELException("Impossible to find type \"" + definition.getTypeQName() + "\" in all schemas");
				}

				final Schema schema = SchemaFactory.newInstance().newSchema();
				schema.setTargetNamespace(definition.getTypeQName().getNamespaceURI());
				if(definition.getTypeQName().getPrefix() != null) {
					schema.getAllNamespaces().addNamespace(definition.getTypeQName().getPrefix(), definition.getTypeQName().getNamespaceURI());
				}
				schema.setElementFormDefault(FormChoice.QUALIFIED);
				schema.setAttributeFormDefault(FormChoice.QUALIFIED);

				final org.ow2.easywsdl.schema.api.Element elmt = schema.createElement();


				elmt.setQName(new QName(definition.getTypeQName().getNamespaceURI(),definition.getQName().getLocalPart(), definition.getTypeQName().getPrefix()));
				elmt.setType(type);

				final Element jDomElmt = XSD2XML.newInstance().generateElement(elmt,"?");
				message.setContent(jDomElmt);

			} else {
				final List<org.ow2.easywsdl.schema.api.Element> elmts = desc.findElementsInAllSchema(definition.getElement());
				if((elmts == null)||(elmts.size() == 0)) {
					throw new BPELException("Impossible to find element");
				}


				final org.ow2.easywsdl.schema.api.Element elmt = elmts.get(0);
				final Element jDomElmt = XSD2XML.newInstance().generateElement(elmt, null);
				message.setContent(jDomElmt);
			}
		} catch (final SchemaException e) {
			throw new BPELException(e);
		}
		return message;
	}
}
