/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.CorrelationValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInitiate;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.InfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class CorrelationValidatorImpl
implements CorrelationValidator {
    private Correlation correlation = null;

    public CorrelationValidatorImpl(Correlation correlation) {
        this.correlation = correlation;
    }

    public void validate() {
        CorrelationSet correlationSet;
        if (this.correlation.getSet() == null || this.correlation.getSet().trim().length() == 0) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlation, new BPELException("In Correlation => The set cannot be null or empty")));
        }
        if (this.correlation.getInitiate() != null && this.correlation.getInitiate().equals((Object)TInitiate.JOIN)) {
            StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.correlation, "In Correlation => [BPEL engine restriction] The join value in initiate attribute is not supported for the moment"));
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlation, new BPELException("In Correlation => [BPEL engine restriction] The join value in initiate attribute is not supported for the moment")));
        }
        if (this.correlation.getPattern() != null) {
            StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.correlation, "In Correlation => [BPEL engine restriction] The pattern attribute is not supported for the moment"));
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlation, new BPELException("In Correlation => [BPEL engine restriction] The pattern attribute is not supported for the moment")));
        }
        BPELProcess bPELProcess = ScopeImpl.getProcess(this.correlation);
        if (this.correlation.getSet() != null && (correlationSet = bPELProcess.getCorrelationSet(this.correlation.getSet())) == null) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlation, new BPELException("In Correlation => Impossible to find the correlation set corresponding to this name " + this.correlation.getSet())));
        }
    }
}

