/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ProcessValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.InfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class ProcessValidatorImpl
implements ProcessValidator {
    private BPELProcess process = null;

    public ProcessValidatorImpl(BPELProcess bPELProcess) {
        this.process = bPELProcess;
    }

    public void validate() {
        TProcess tProcess;
        if (this.process.getName() == null || this.process.getName().trim().length() == 0) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.process, new BPELException("In process => the name of process cannot be null or empty")));
        }
        if (this.process.getTargetNamespace() == null || this.process.getTargetNamespace().trim().length() == 0) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.process, new BPELException("In process => the targetNamespace of process cannot be null or empty")));
        }
        if ((tProcess = (TProcess)((BPELElementImpl)((Object)this.process)).getModel()).getSuppressJoinFailure() != null) {
            StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.process, "In process => [BPEL engine restriction] Sorry, but the suppressJoinFailure attribute is ignored for the moment"));
        }
        if (tProcess.getExitOnStandardFault() != null) {
            StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.process, "In process => [BPEL engine restriction] Sorry, but the exitOnStandardFault attribute is ignored for the moment"));
        }
        if (tProcess.getPartnerLinks() == null || tProcess.getPartnerLinks().getPartnerLink() == null || tProcess.getPartnerLinks().getPartnerLink().size() == 0) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.process, new BPELException("In process => A process MUST have at less one partnerLink")));
        }
        if (tProcess.getVariables() == null || tProcess.getVariables().getVariable() == null || tProcess.getVariables().getVariable().size() == 0) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.process, new BPELException("In process => A process MUST have at less one variable")));
        }
        if (tProcess.getPartnerLinks() != null && tProcess.getPartnerLinks().getPartnerLink() != null && tProcess.getPartnerLinks().getPartnerLink().size() > 0) {
            boolean bl = false;
            for (TPartnerLink tPartnerLink : tProcess.getPartnerLinks().getPartnerLink()) {
                if (tPartnerLink.getMyRole() == null || tPartnerLink.getMyRole().trim().length() <= 0) continue;
                bl = true;
            }
            if (!bl) {
                StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.process, "In process => [BPEL engine restriction] A process MUST have at less one partnerLink with a myRole attribute"));
                StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.process, new BPELException("In process => [BPEL engine restriction] A process MUST have at less one partnerLink with a myRole attribute")));
            }
        }
        if (tProcess.getExtensions() != null && tProcess.getExtensions().getExtension().size() > 0) {
            StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.process, "In process => [BPEL engine restriction] Sorry, but the extensions are not supported for the moment"));
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.process, new BPELException("In process => [BPEL engine restriction] Sorry, but the extensions are not supported for the moment")));
        }
        if (tProcess.getMessageExchanges() != null && tProcess.getMessageExchanges().getMessageExchange().size() > 0) {
            StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.process, "In process => [BPEL engine restriction] Sorry, but the messageExchanges are not supported for the moment"));
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.process, new BPELException("In process => [BPEL engine restriction] Sorry, but the extensions are not supported for the moment")));
        }
        if (tProcess.getEventHandlers() != null && (tProcess.getEventHandlers().getOnEvent().size() > 0 || tProcess.getEventHandlers().getOnAlarm().size() > 0)) {
            StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.process, "In process => [BPEL engine restriction] Sorry, but the eventHandler are not supported for the moment"));
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.process, new BPELException("In process => [BPEL engine restriction] Sorry, but the extensions are not supported for the moment")));
        }
    }
}

