/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.BPELBooleanExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.BPELExpressionImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ParseException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import java.io.ByteArrayInputStream;
import java.util.logging.Logger;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELBooleanExpressionImpl
extends BPELExpressionImpl<Boolean>
implements BPELBooleanExpression {
    private Logger log = Logger.getLogger(BPELBooleanExpressionImpl.class.getName());
    private static final long serialVersionUID = 1L;
    private BPELProcess bpeldefinition;

    public BPELBooleanExpressionImpl(TExpression tExpression, BPELElement bPELElement) {
        super(Constants._Condition_QNAME, tExpression, bPELElement);
        this.bpeldefinition = ScopeImpl.getProcess(bPELElement);
    }

    public Boolean evaluate(Scope scope) throws CoreException {
        Boolean bl = null;
        String string = "";
        if (this.getContent() != null) {
            string = this.getContent();
        }
        try {
            Element element;
            this.log.finest("boolean expression to evaluate: " + string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(byteArrayInputStream);
            ASTStart aSTStart = expressionAnalyzer.Start();
            ExpressionDumpVisitor expressionDumpVisitor = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
            if (!this.log.getName().equals(BPELBooleanExpressionImpl.class.getName())) {
                expressionDumpVisitor.setLog(this.log);
            }
            if ((element = aSTStart.jjtAccept(expressionDumpVisitor, null)) instanceof BPELException) {
                throw (BPELException)element;
            }
            if (!(element instanceof Element)) {
                throw new BPELException("result unknown");
            }
            Element element2 = element;
            bl = Boolean.parseBoolean(element2.getText());
        }
        catch (BPELException bPELException) {
            throw new CoreException("Impossible to evaluate expression: " + string, (Throwable)((Object)bPELException));
        }
        catch (ParseException parseException) {
            throw new CoreException("Impossible to evaluate expression: " + string, (Throwable)parseException);
        }
        return bl;
    }

    public BPELProcess getBpeldefinition() {
        return this.bpeldefinition;
    }

    public void setBpeldefinition(BPELProcess bPELProcess) {
        this.bpeldefinition = bPELProcess;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public Expression<String, Boolean> copypaste() {
        BPELBooleanExpressionImpl bPELBooleanExpressionImpl = new BPELBooleanExpressionImpl((TExpression)this.getModel(), (BPELElement)this.getParent());
        return bPELBooleanExpressionImpl;
    }
}

