/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.api.function;

import com.ebmwebsourcing.easybpel.xpath.exp.api.Constants;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractXPathFunction<T> implements Function<T> {

	
	public AbstractXPathFunction(final String ns) throws XPathExpressionException {
		if((ns != null) && !ns.equals(Constants.XPATH_FUNCTIONS_NAMESPACE)) {
			throw new XPathExpressionException("this namespace is not supported for this function: " + this.getClass().getSimpleName() + ". Only functions of namespaces " + Constants.XPATH_FUNCTIONS_NAMESPACE + " and " + Constants.BPEL_20_EXECUTABLE_NAMESPACE + " are supported");
		}
	}
}
