/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELAssignementExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.AssignementExpression.Assigner;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELAssignementExpressionImpl implements BPELAssignementExpression {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Logger log = Logger.getLogger(BPELAssignementExpressionImpl.class.getName());

	private final Copy copy;
	
	private BPELExpression left;
	
	private BPELExpression right;
	
	private Assigner assigner;
	
	private BPELProcess bpelDefinition;
	
	public BPELAssignementExpressionImpl(final Copy copy, final BPELProcess definition, final Assigner bpelAssigner) {
		//super(((BPELElementImpl)copy).getTag(), null, (BPELElementImpl)copy);
		//this.assigner = new BPELAssigner(definition);
		this.assigner = bpelAssigner;
		if(!this.log.getName().equals(BPELAssignementExpressionImpl.class.getName())) {
			this.assigner.setLog(this.log);
		}
		this.copy = copy;
		this.bpelDefinition = definition;
		this.left = (BPELExpression) this.copy.getTo().copypaste();
		this.right = (BPELExpression) this.copy.getFrom().copypaste();
	}

	public Assigner getAssigner() {
		return this.assigner;
	}
	
	public void setAssigner(final Assigner assigner) {
		this.assigner = assigner;
	}

	public BPELExpression<?> getLeft() {
		return this.left;
	}

	public BPELExpression<?> getRight() {
		return this.right;
	}

	public BPELProcess getBpeldefinition() {
		return this.bpelDefinition;
	}

	public void setBpeldefinition(final BPELProcess bpeldefinition) {
		this.bpelDefinition = bpeldefinition;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

	public void setLeft(final Expression left) {
		this.left = (BPELExpression<?>) left;
	}

	public void setRight(final Expression right) {
		this.right = (BPELExpression<?>) right;
	}
	
}
