/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;
import java.util.logging.Logger;

import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.XPath;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class XPathAnalyzer {

	private static Logger log = Logger.getLogger(XPathAnalyzer.class.getName());


	private Descriptions desc;

	private XPath engine;

	private NamespaceContext xpathContext;

	public XPathAnalyzer() {

	}

	public Element evaluate(final String xpathExpression, final Element source, final NamespaceMapperImpl context) throws BPELException {
		final List<String> xpathExpressions = new ArrayList<String>();
		xpathExpressions.add(xpathExpression);
		return this.evaluate(xpathExpressions, source, context);
	}

	public Element evaluate(final List<String> xpathExpressions, final Element source, final NamespaceMapperImpl context) throws BPELException {
		Element target = null;
		try {
			for(final String xpathExpression: xpathExpressions) {
				this.engine = new JDOMXPath(xpathExpression);

				this.xpathContext = new SimpleNamespaceContext();

				for(final Entry<String, String> entry: (context).getNamespaces().entrySet()) {
					((SimpleNamespaceContext)this.xpathContext).addNamespace(entry.getKey(), entry.getValue());
				}

				this.engine.setNamespaceContext(this.xpathContext);
				final Object res = this.engine.selectSingleNode(source);
				if(res instanceof Document) {
					target = ((Document)res).getRootElement();
					log.finest("this xpath expression " + xpathExpression + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
					break;
				} else if(res instanceof Element) {
					target = (Element)res;
					log.finest("this xpath expression " + xpathExpression + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
					break;
				} 
			}

			if(target == null) {
				log.finest("namespace used: " + (context).getNamespaces());
				log.finest("No xpath expressions " + xpathExpressions + " match with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
			}

		} catch (final JaxenException e) {
			throw new BPELException(e);
		}

		return target;
	}

}
