/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.XPath;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathAnalyzer {
    private static Logger log = Logger.getLogger(XPathAnalyzer.class.getName());
    private Descriptions desc;
    private XPath engine;
    private NamespaceContext xpathContext;

    public Element evaluate(String xpathExpression, Element source, NamespaceMapperImpl context) throws BPELException {
        ArrayList<String> xpathExpressions = new ArrayList<String>();
        xpathExpressions.add(xpathExpression);
        return this.evaluate(xpathExpressions, source, context);
    }

    public Element evaluate(List<String> xpathExpressions, Element source, NamespaceMapperImpl context) throws BPELException {
        Element target = null;
        try {
            for (String xpathExpression : xpathExpressions) {
                this.engine = new JDOMXPath(xpathExpression);
                this.xpathContext = new SimpleNamespaceContext();
                for (Map.Entry entry : context.getNamespaces().entrySet()) {
                    ((SimpleNamespaceContext)this.xpathContext).addNamespace((String)entry.getKey(), (String)entry.getValue());
                }
                this.engine.setNamespaceContext(this.xpathContext);
                Object res = this.engine.selectSingleNode((Object)source);
                if (res instanceof Document) {
                    target = ((Document)res).getRootElement();
                    log.finest("this xpath expression " + xpathExpression + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
                    break;
                }
                if (!(res instanceof Element)) continue;
                target = (Element)res;
                log.finest("this xpath expression " + xpathExpression + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
                break;
            }
            if (target == null) {
                log.finest("namespace used: " + context.getNamespaces());
                log.finest("No xpath expressions " + xpathExpressions + " match with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
            }
        }
        catch (JaxenException e) {
            throw new BPELException((Throwable)e);
        }
        return target;
    }
}

