/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer;

import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.Expression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.Node;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.SimpleNode;

public class ExpressionNode
extends SimpleNode {
    private String image;

    public ExpressionNode(int n) {
        super(n);
    }

    public ExpressionNode(Expression expression, int n) {
        super(expression, n);
    }

    public static Node jjtCreate(int n) {
        return new ExpressionNode(n);
    }

    public static Node jjtCreate(Expression expression, int n) {
        return new ExpressionNode(expression, n);
    }

    public void setImage(String string) {
        this.image = string;
    }

    public String getImage() {
        return this.image;
    }

    public static Multiplicative getMultiplicative(String string) {
        Multiplicative multiplicative = null;
        if ("*".equals(string)) {
            multiplicative = Multiplicative.MULT;
        } else if ("/".equals(string)) {
            multiplicative = Multiplicative.DIV;
        } else if ("%".equals(string)) {
            multiplicative = Multiplicative.MOD;
        }
        return multiplicative;
    }

    public static Inequality getInequality(String string) {
        Inequality inequality = null;
        if ("<".equals(string)) {
            inequality = Inequality.INFERIOR;
        } else if ("<=".equals(string)) {
            inequality = Inequality.INFERIOR_EQUALS;
        } else if (">".equals(string)) {
            inequality = Inequality.SUPERIOR;
        } else if (">=".equals(string)) {
            inequality = Inequality.SUPERIOR_EQUALS;
        }
        return inequality;
    }

    public static Equality getEquality(String string) {
        Equality equality = null;
        if ("=".equals(string)) {
            equality = Equality.EQUAL;
        } else if ("!=".equals(string)) {
            equality = Equality.DIFFERENT;
        }
        return equality;
    }

    public static boolean isPlus(String string) {
        boolean bl = false;
        if (string.equals("+")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqual(String string) {
        boolean bl = false;
        if (string.equals("==")) {
            bl = true;
        }
        return bl;
    }

    public static boolean getBoolean(String string) {
        return Boolean.valueOf(string);
    }

    public static String getCharacter(String string) {
        return string.replaceAll("'", "");
    }

    public static Float getFloat(String string) {
        return Float.valueOf(Float.parseFloat(string));
    }

    public static Integer getInteger(String string) {
        return Integer.parseInt(string);
    }

    public static String getString(String string) {
        return string.substring(1, string.length() - 1);
    }

    public static String getAttributeName(String string) {
        return string.substring(1, string.length());
    }

    public static enum Multiplicative {
        MULT("*"),
        DIV("/"),
        MOD("%");

        private String value = "";

        private Multiplicative(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(String string) {
            return this.value().equals(string);
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Inequality {
        INFERIOR("<"),
        SUPERIOR(">"),
        INFERIOR_EQUALS("<="),
        SUPERIOR_EQUALS(">=");

        private String value = "";

        private Inequality(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(String string) {
            return this.value().equals(string);
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Equality {
        EQUAL("="),
        DIFFERENT("!=");

        private String value = "";

        private Equality(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(String string) {
            return this.value().equals(string);
        }

        public String toString() {
            return this.value;
        }
    }
}

