/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.function;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.AbstractBPELFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.DoXslTransformFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.XSLParam;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.ow2.easywsdl.schema.util.XMLPrettyPrinter;

public class DoXslTransformFunctionImpl
extends AbstractBPELFunction<Element>
implements DoXslTransformFunction {
    private static Logger log = Logger.getLogger(DoXslTransformFunctionImpl.class.getName());
    private final URL xslStyleSheet;
    private final Element nodeset;
    private final List<XSLParam> xslParams;

    public DoXslTransformFunctionImpl(String string, URL uRL, Element element, List<XSLParam> list) throws XPathExpressionException {
        super(string);
        this.xslStyleSheet = uRL;
        this.nodeset = element;
        this.xslParams = list;
    }

    public Element process() throws XPathExpressionException {
        Element element = null;
        if (this.xslStyleSheet == null || this.nodeset == null) {
            throw new XPathExpressionException("Wrong number of argument for the bpws:doXslTransform function.");
        }
        try {
            DOMOutputter dOMOutputter = new DOMOutputter();
            org.w3c.dom.Document document = dOMOutputter.output(this.nodeset.getDocument());
            org.w3c.dom.Document document2 = DoXslTransformFunctionImpl.process(this.xslStyleSheet, document, this.xslParams);
            DOMBuilder dOMBuilder = new DOMBuilder();
            Document document3 = dOMBuilder.build(document2);
            element = document3.getRootElement();
        }
        catch (JDOMException jDOMException) {
            throw new XPathExpressionException((Throwable)jDOMException);
        }
        return element;
    }

    public static org.w3c.dom.Document process(URL uRL, org.w3c.dom.Document document, List<XSLParam> list) throws XPathExpressionException {
        org.w3c.dom.Document document2 = null;
        if (uRL == null || document == null) {
            throw new XPathExpressionException("Wrong number of argument for the bpws:doXslTransform function.");
        }
        StreamSource streamSource = null;
        try {
            streamSource = new StreamSource(uRL.openStream());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            if (list != null) {
                for (XSLParam object2 : list) {
                    transformer.setParameter(object2.getName(), object2.getValue());
                }
            }
            DOMSource dOMSource = new DOMSource(document);
            DOMResult dOMResult = new DOMResult();
            transformer.transform(dOMSource, dOMResult);
            document2 = (org.w3c.dom.Document)dOMResult.getNode();
            log.finest("xsl stylesheet = " + uRL);
            log.finest("xsl source     = " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)document));
            log.finest("xsl params     = " + list);
            log.finest("xsl result = " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)document2));
        }
        catch (IOException iOException) {
            throw new XPathExpressionException((Throwable)iOException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XPathExpressionException((Throwable)transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new XPathExpressionException((Throwable)transformerException);
        }
        finally {
            try {
                streamSource.getInputStream().close();
            }
            catch (Exception exception) {}
        }
        return document2;
    }
}

