/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.util;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.VariablePart;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;

public class ExpressionUtil {
    public static String convertVariable2Expression(VariablePart var) throws XPathExpressionException {
        String expression = null;
        if (var != null) {
            expression = "$" + var.getVariable();
            if (var.getPart() != null) {
                expression = expression + "." + var.getPart();
            }
            if (var.getQuery() != null) {
                if (!var.getQuery().getQueryLanguage().toString().equals("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0")) {
                    throw new XPathExpressionException("this query language (" + var.getQuery().getQueryLanguage() + ") is not recognized. Only XPATH1.0 language (urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0) is supported");
                }
                expression = var.getQuery().getContent().startsWith("/") ? expression + var.getQuery().getContent().trim() : expression + "/" + var.getQuery().getContent().trim();
            }
        }
        return expression.trim();
    }

    public static List<String> createXPathExpressionByReplacingPartByElement(String partName, BPELVariable definition, String xpathExpression, BPELProcess bpelDefinition) throws XPathExpressionException {
        ArrayList<String> xpathExpressions = new ArrayList<String>();
        String expWithoutVarAndPart = null;
        if (xpathExpression.indexOf("/") > 0) {
            expWithoutVarAndPart = xpathExpression.substring(xpathExpression.indexOf("/"));
        }
        if (expWithoutVarAndPart == null && partName == null) {
            xpathExpression = "/";
            xpathExpressions.add(xpathExpression);
        } else if (definition.getMessageType() != null) {
            MessageImpl msg = bpelDefinition.getImports().getMessage(definition.getMessageType());
            if (msg == null) {
                throw new XPathExpressionException("BPELError: the message cannot be null: " + definition.getMessageType());
            }
            Part part = msg.getPart(new QName(msg.getQName().getNamespaceURI(), partName));
            if (part == null) {
                throw new XPathExpressionException("Impossible to find part corresponding to " + partName);
            }
            if (part.getElement() != null) {
                String prefix = bpelDefinition.getNamespaceContext().getPrefix(part.getElement().getQName().getNamespaceURI());
                if (prefix == null && (prefix = bpelDefinition.getImports().getNamespaces().getPrefix(part.getElement().getQName().getNamespaceURI())) != null) {
                    if (bpelDefinition.getNamespaceContext().getNamespaceURI(prefix) == null) {
                        bpelDefinition.getNamespaceContext().addNamespace(prefix, part.getElement().getQName().getNamespaceURI());
                    } else {
                        int i = 0;
                        String nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
                        while (nsAlreadyExist != null) {
                            nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + ++i);
                        }
                        prefix = "cns" + i;
                        bpelDefinition.getNamespaceContext().addNamespace(prefix, part.getElement().getQName().getNamespaceURI());
                    }
                }
                String localName = part.getElement().getQName().getLocalPart();
                if (expWithoutVarAndPart == null) {
                    expWithoutVarAndPart = "";
                }
                if (prefix != null) {
                    String validRpcXpathExpression = prefix + ":" + localName + expWithoutVarAndPart;
                    xpathExpressions.add(validRpcXpathExpression);
                }
                String degradedRpcXpathExpression = localName + expWithoutVarAndPart;
                xpathExpressions.add(degradedRpcXpathExpression);
                if (prefix != null) {
                    String validDocXpathExpression = "/" + prefix + ":" + localName + expWithoutVarAndPart;
                    xpathExpressions.add(validDocXpathExpression);
                }
                String degradedDocXpathExpression = "/" + localName + expWithoutVarAndPart;
                xpathExpressions.add(degradedDocXpathExpression);
            } else if (part.getPartQName() != null) {
                String prefix = bpelDefinition.getNamespaceContext().getPrefix(part.getPartQName().getNamespaceURI());
                if (prefix == null && (prefix = bpelDefinition.getImports().getNamespaces().getPrefix(part.getType().getQName().getNamespaceURI())) != null) {
                    if (bpelDefinition.getNamespaceContext().getNamespaceURI(prefix) == null) {
                        bpelDefinition.getNamespaceContext().addNamespace(prefix, part.getType().getQName().getNamespaceURI());
                    } else {
                        int i = 0;
                        String nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
                        while (nsAlreadyExist != null) {
                            nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + ++i);
                        }
                        prefix = "cns" + i;
                        bpelDefinition.getNamespaceContext().addNamespace(prefix, part.getType().getQName().getNamespaceURI());
                    }
                }
                String localName = part.getPartQName().getLocalPart();
                if (expWithoutVarAndPart == null) {
                    expWithoutVarAndPart = "";
                }
                if (prefix != null) {
                    String validRpcXpathExpression = prefix + ":" + localName + expWithoutVarAndPart;
                    xpathExpressions.add(validRpcXpathExpression);
                }
                String degradedRpcXpathExpression = localName + expWithoutVarAndPart;
                xpathExpressions.add(degradedRpcXpathExpression);
                if (prefix != null) {
                    String validDocXpathExpression = "/" + prefix + ":" + localName + expWithoutVarAndPart;
                    xpathExpressions.add(validDocXpathExpression);
                }
                String degradedDocXpathExpression = "/" + localName + expWithoutVarAndPart;
                xpathExpressions.add(degradedDocXpathExpression);
            }
        } else if (definition.getTypeQName() != null) {
            xpathExpression = xpathExpression.replace("$", "/");
            xpathExpressions.add(xpathExpression);
            xpathExpression = xpathExpression.replaceFirst("/", "/" + definition.getTypeQName().getPrefix() + ":");
            xpathExpressions.add(xpathExpression);
        } else if (definition.getElement() != null) {
            if (expWithoutVarAndPart == null) {
                expWithoutVarAndPart = "";
            }
            xpathExpression = definition.getElement().getLocalPart() + expWithoutVarAndPart;
            xpathExpressions.add(xpathExpression);
            if (expWithoutVarAndPart.trim().length() > 0) {
                xpathExpression = expWithoutVarAndPart.replaceFirst("/", "");
                xpathExpressions.add(xpathExpression);
            }
            if (definition.getElement().getPrefix() != null) {
                xpathExpression = definition.getElement().getPrefix() + ":" + definition.getElement().getLocalPart() + expWithoutVarAndPart;
            }
            xpathExpressions.add(xpathExpression);
        }
        return xpathExpressions;
    }
}

