/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl.function;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.AbstractBPELFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.DoXslTransformFunction;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class DoXslTransformFunctionImpl extends AbstractBPELFunction<Element> implements DoXslTransformFunction {

	private static Logger log = Logger.getLogger(DoXslTransformFunctionImpl.class.getName());


	private final URL xslStyleSheet;

	private final Element nodeset;

	private final List<XSLParam> xslParams;

	public DoXslTransformFunctionImpl(final String ns, final URL fileName, final Element nodeset, final List<XSLParam> xslParams) throws XPathExpressionException {
		super(ns);
		this.xslStyleSheet = fileName;
		this.nodeset = nodeset;
		this.xslParams = xslParams;
	}

	public Element process() throws XPathExpressionException {
		Element res = null;
		if ((this.xslStyleSheet == null)||(this.nodeset == null)) {
			throw new XPathExpressionException(
					"Wrong number of argument for the bpws:doXslTransform function.");
		}

		try {

			// transform jdom to dom
			final DOMOutputter converter = new DOMOutputter();
			final org.w3c.dom.Document domDocument = converter.output(this.nodeset.getDocument());
			final Document doc = DoXslTransformFunctionImpl.process(this.xslStyleSheet, domDocument, this.xslParams);

			// transform dom to jdom
			final DOMBuilder builder = new DOMBuilder();
			final org.jdom.Document jdomDocument = builder.build(doc);


			res = jdomDocument.getRootElement();

		} catch (final JDOMException e) {
			throw new XPathExpressionException(e);
		} 
		return res;
	}

	public static Document process(final URL xslStyleSheet, final Document nodeset, final List<XSLParam> xslParams) throws XPathExpressionException {
		Document res = null;
		if ((xslStyleSheet == null)||(nodeset == null)) {
			throw new XPathExpressionException(
			"Wrong number of argument for the bpws:doXslTransform function.");
		}

		StreamSource styleSheet = null;
		try {
			styleSheet = new StreamSource(xslStyleSheet.openStream());
			final TransformerFactory tFactory = TransformerFactory.newInstance();
			final Transformer transformer = tFactory.newTransformer(styleSheet);

			// parameters
			if(xslParams != null) {
				for(final XSLParam param: xslParams) {
					transformer.setParameter(param.getName(), param.getValue());
				}
			}

			// source
			final DOMSource source = new DOMSource(nodeset);

			// result
			final DOMResult result = new DOMResult();

	         // info
            log.finest("xsl stylesheet = " + xslStyleSheet);
            log.finest("xsl source     = " + XMLPrettyPrinter.prettyPrint(nodeset));
            log.finest("xsl params     = " + xslParams);

            // result
            
			// transformation
			transformer.transform(source, result);
			
			res = (Document) result.getNode();

			log.finest("xsl result = " + XMLPrettyPrinter.prettyPrint(res));

		} catch (final IOException e) {
			throw new XPathExpressionException(e);
		} catch (final TransformerConfigurationException e) {
			throw new XPathExpressionException(e);
		} catch (final TransformerException e) {
			throw new XPathExpressionException(e);
		} finally {
			try {
				styleSheet.getInputStream().close();
			} catch (final Exception e) {
				// nothing
			}
		}
		return res;
	}

}
