/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.verification;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.verification.TypeVerifier;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jdom.Element;

public class TypeVerifier2Impl
implements TypeVerifier {
    public Class<?> compare(Element element, Element element2) throws XPathExpressionException {
        Class clazz = null;
        if (this.isInteger(element) && this.isInteger(element2)) {
            clazz = Integer.class;
        } else if (this.isInteger(element) && this.isLong(element2)) {
            clazz = Long.class;
        } else if (this.isInteger(element) && this.isDouble(element2)) {
            clazz = Double.class;
        } else if (this.isLong(element) && this.isInteger(element2)) {
            clazz = Long.class;
        } else if (this.isDouble(element) && this.isInteger(element2)) {
            clazz = Double.class;
        } else if (this.isLong(element) && this.isLong(element2)) {
            clazz = Long.class;
        } else if (this.isLong(element) && this.isDouble(element2)) {
            clazz = Double.class;
        } else if (this.isDouble(element) && this.isLong(element2)) {
            clazz = Double.class;
        } else if (this.isDouble(element) && this.isDouble(element2)) {
            clazz = Double.class;
        } else if (this.isBoolean(element) && this.isBoolean(element2)) {
            clazz = Boolean.class;
        } else if (this.isDateTime(element) && this.isDateTime(element2)) {
            clazz = Date.class;
        } else if (this.isString(element) && this.isString(element2)) {
            clazz = String.class;
        }
        return clazz;
    }

    public boolean isInteger(Element element) throws XPathExpressionException {
        try {
            Integer.parseInt(element.getTextNormalize());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public boolean isLong(Element element) throws XPathExpressionException {
        try {
            Long.parseLong(element.getTextNormalize());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public boolean isDouble(Element element) throws XPathExpressionException {
        try {
            Integer.parseInt(element.getTextNormalize());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public boolean isDateTime(Element element) throws XPathExpressionException {
        String string = element.getTextNormalize();
        assert (!string.isEmpty());
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(element.getText());
            xMLGregorianCalendar.toGregorianCalendar().getTime();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isString(Element element) throws XPathExpressionException {
        boolean bl = !element.getTextNormalize().isEmpty();
        return bl;
    }

    public boolean isBoolean(Element element) throws XPathExpressionException {
        try {
            return Boolean.parseBoolean(element.getTextNormalize().toLowerCase());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                boolean bl = Integer.parseInt(element.getTextNormalize()) == 1;
                return bl;
            }
            catch (NumberFormatException numberFormatException2) {
                return false;
            }
        }
    }

    public int getIntValue(Element element) {
        String string = element.getTextNormalize();
        assert (!string.isEmpty());
        return Integer.parseInt(string);
    }

    public long getLongValue(Element element) {
        String string = element.getTextNormalize();
        assert (!string.isEmpty());
        return Long.parseLong(string);
    }

    public double getDoubleValue(Element element) {
        String string = element.getTextNormalize();
        assert (!string.isEmpty());
        return Double.parseDouble(string);
    }

    public String getStringValue(Element element) {
        String string = element.getTextNormalize();
        assert (!string.isEmpty());
        return string;
    }

    public boolean getBooleanValue(Element element) {
        String string = element.getTextNormalize();
        assert (!string.isEmpty());
        try {
            return Boolean.parseBoolean(element.getTextNormalize().toLowerCase());
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(element.getTextNormalize()) == 1;
        }
    }

    public Date getDateTimeValue(Element element) {
        String string = element.getTextNormalize();
        assert (!string.isEmpty());
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(element.getText());
            return xMLGregorianCalendar.toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new UncheckedException((Throwable)datatypeConfigurationException);
        }
    }
}

