/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfiguration;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfigurationException;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfigurationList;
import com.ebmwebsourcing.easybpel.extended.service.activity.impl.ExtendedActivityServiceImpl;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import junit.framework.TestCase;

public class ExtendedActivityServiceTest
extends TestCase {
    public void testReadExtendedActivitiesConfigureService() throws MalformedURLException, JarException, ExtendedActivityConfigurationException {
        URL fileName = Thread.currentThread().getContextClassLoader().getResource("ExtendedActivityConfiguration.xml");
        System.out.println("fileName = " + fileName);
        ExtendedActivityServiceImpl service = new ExtendedActivityServiceImpl(null);
        ExtendedActivityConfigurationList conf = service.loadExtendedActivitiesConfigure(fileName);
        ExtendedActivityServiceTest.assertNotNull((Object)conf);
        System.out.println("conf = " + conf.getExtendedActivityConf());
        ExtendedActivityServiceTest.assertEquals((int)1, (int)conf.getExtendedActivityConf().size());
    }

    public void testLoadExtendedActivitiesConfigureService() throws MalformedURLException, JarException, ExtendedActivityConfigurationException, ClassNotFoundException {
        String fileName = new File(".") + "/src/test/resources/lib/easybpel.extended.activities.package.debug-1.1-SNAPSHOT.jar";
        System.out.println("fileName = " + fileName);
        ExtendedActivityServiceImpl service = new ExtendedActivityServiceImpl(null);
        List confs = service.getExtendedActivitiesConfiguresInJar(new File(fileName).toURL());
        ExtendedActivityServiceTest.assertNotNull((Object)confs);
        ExtendedActivityServiceTest.assertEquals((int)1, (int)confs.size());
        for (ExtendedActivityConfigurationList conf : confs) {
            System.out.println("conf = " + conf.getExtendedActivityConf());
            ExtendedActivityServiceTest.assertEquals((int)3, (int)conf.getExtendedActivityConf().size());
            for (ExtendedActivityConfiguration init : conf.getExtendedActivityConf()) {
                System.out.println("className: " + init.getClassName());
            }
        }
    }
}

