/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.extended.service.activity.impl;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivitiesConfigure;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivitiesConfigureException;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityInit;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.inout.ExtendedActivitiesConfigureReader;
import com.ebmwebsourcing.easybpel.extended.activities.configure.impl.inout.ExtendedActivitiesConfigureReaderImpl;
import com.ebmwebsourcing.easybpel.extended.service.activity.api.ExtendedActivityService;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtendedActivity;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.ExtendedBehaviourServiceImpl;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedActivityServiceImpl
extends ExtendedBehaviourServiceImpl
implements ExtendedActivityService {
    private Logger log = Logger.getLogger(ExtendedActivityServiceImpl.class.getName());
    private List<ExtendedActivityInit> extendedActivitiesInits = Collections.synchronizedList(new ArrayList());
    private ExtendedActivitiesConfigureReader reader;
    private ExtendedActivitiesConfigureException initEx = null;

    public ExtendedActivityServiceImpl(Engine engine) {
        super(engine);
        try {
            this.reader = new ExtendedActivitiesConfigureReaderImpl();
        }
        catch (ExtendedActivitiesConfigureException e) {
            this.initEx = e;
        }
    }

    public void run() {
        try {
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.severe("Error in auto trash service: " + e.getMessage());
        }
    }

    @Override
    public ExtendedActivitiesConfigure loadExtendedActivitiesConfigure(URL url) throws ExtendedActivitiesConfigureException {
        ExtendedActivitiesConfigure res = null;
        if (url == null) {
            throw new ExtendedActivitiesConfigureException("url cannot be null!!!");
        }
        if (this.initEx != null) {
            throw this.initEx;
        }
        try {
            res = this.reader.read(url.toURI());
            this.extendedActivitiesInits.addAll(res.getExtendedActivitiesInit());
        }
        catch (URISyntaxException e) {
            throw new ExtendedActivitiesConfigureException((Throwable)e);
        }
        return res;
    }

    @Override
    public List<ExtendedActivityInit> getAllExtendedActivitiesInit() {
        return this.extendedActivitiesInits;
    }

    @Override
    public ExtendedActivityInit findExtendedActivity(QName tag) {
        ExtendedActivityInit res = null;
        for (ExtendedActivityInit init : this.extendedActivitiesInits) {
            if (!init.getTag().getLocalPart().equals(tag.getLocalPart()) || !init.getTag().getNamespaceURI().equals(tag.getNamespaceURI())) continue;
            res = init;
            break;
        }
        return res;
    }

    @Override
    public List<ExtendedActivitiesConfigure> getExtendedActivitiesConfiguresInJar(URL jarUrl) throws ExtendedActivitiesConfigureException {
        ArrayList<ExtendedActivitiesConfigure> res = new ArrayList<ExtendedActivitiesConfigure>();
        try {
            this.getExtendedBehaviourInJar(jarUrl);
            System.out.println("test = " + this.classLoader.getResources());
            List xmlFiles = (List)this.classLoader.getResources().get("xml");
            if (xmlFiles != null) {
                for (String file : xmlFiles) {
                    URL url = this.classLoader.getResource(file);
                    if (url == null) continue;
                    try {
                        res.add(this.loadExtendedActivitiesConfigure(url));
                    }
                    catch (ExtendedActivitiesConfigureException e) {}
                }
            }
            List ext = this.getClassInJar(this.classLoader, ExtendedActivity.class);
            System.out.println("ext = " + ext);
        }
        catch (JarException e) {
            throw new ExtendedActivitiesConfigureException((Throwable)e);
        }
        return res;
    }
}

