/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.extended.service.activity.impl;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfiguration;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfigurationException;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfigurationList;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.inout.ExtendedActivityConfigurationListReader;
import com.ebmwebsourcing.easybpel.extended.activities.configure.impl.inout.ExtendedActivityConfigurationListReaderImpl;
import com.ebmwebsourcing.easybpel.extended.service.activity.api.ExtendedActivityService;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtendedActivity;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.ExtendedBehaviourServiceImpl;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarException;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarLoader;

public class ExtendedActivityServiceImpl extends ExtendedBehaviourServiceImpl implements ExtendedActivityService {

	private Logger log = Logger.getLogger(ExtendedActivityServiceImpl.class.getName());

	private List<ExtendedActivityConfiguration> extendedActivitiesInits = Collections.synchronizedList(new ArrayList<ExtendedActivityConfiguration>());

	private ExtendedActivityConfigurationListReader reader;

	private ExtendedActivityConfigurationException initEx = null;

	public ExtendedActivityServiceImpl(Engine engine) {
		super(engine);
		try {
			this.reader = new ExtendedActivityConfigurationListReaderImpl();
		} catch (ExtendedActivityConfigurationException e) {
			this.initEx = e;
		} 
	}

	public void run() {
		try {

			Thread.sleep(this.getRefreshFrequency());

		} catch (Exception e) {
			e.printStackTrace();
			log.severe("BPELError in auto trash service: " + e.getMessage());
		} 	
	}

	public ExtendedActivityConfigurationList loadExtendedActivitiesConfigure(URL url) throws ExtendedActivityConfigurationException {
		ExtendedActivityConfigurationList res = null;
		if(url == null) {
			throw new ExtendedActivityConfigurationException("url cannot be null!!!");
		}
		if(initEx != null) {
			throw initEx;
		}
		try {
			res = this.reader.read(url.toURI());
			this.extendedActivitiesInits.addAll(res.getExtendedActivityConf());

		} catch (URISyntaxException e) {
			throw new ExtendedActivityConfigurationException(e);
		}
		return res;
	}

	public List<ExtendedActivityConfiguration> getAllExtendedActivitiesInit() {
		return this.extendedActivitiesInits;
	}

	public ExtendedActivityConfiguration findExtendedActivity(QName tag) {
		ExtendedActivityConfiguration res = null;
		for(ExtendedActivityConfiguration init: this.extendedActivitiesInits) {
			if(init.getTag().getLocalPart().equals(tag.getLocalPart())
					&& init.getTag().getNamespaceURI().equals(tag.getNamespaceURI())) {
				res = init;
				break;
			}
		}
		return res;
	}

	public List<ExtendedActivityConfigurationList> getExtendedActivitiesConfiguresInJar(
			URL jarUrl) throws ExtendedActivityConfigurationException {
		List<ExtendedActivityConfigurationList> res = new ArrayList<ExtendedActivityConfigurationList>();

		try {
			this.getExtendedBehaviourInJar(jarUrl);
			//classLoader = new JarLoader(jarUrl,Thread.currentThread().getContextClassLoader());


			List<String> xmlFiles = ((JarLoader)this.classLoader).getResources().get("xml");
			if(xmlFiles != null) {
				for(String file: xmlFiles) {
					URL url = this.classLoader.getResource(file);
					if(url != null) {
						try {
							res.add(this.loadExtendedActivitiesConfigure(url));
						} catch (ExtendedActivityConfigurationException e) {
							// do nothing
						}
					}
				}
			}
			
			List<Class<? extends ExtendedActivity>> ext = this.getClassInJar(classLoader, ExtendedActivity.class);
		} catch (JarException e) {
			throw new ExtendedActivityConfigurationException(e);
		}
		return res;
	}







}
