/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.extended.service.activity.impl;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfiguration;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfigurationException;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfigurationList;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.inout.ExtendedActivityConfigurationListReader;
import com.ebmwebsourcing.easybpel.extended.activities.configure.impl.inout.ExtendedActivityConfigurationListReaderImpl;
import com.ebmwebsourcing.easybpel.extended.service.activity.api.ExtendedActivityService;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtendedActivity;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.ExtendedBehaviourServiceImpl;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class ExtendedActivityServiceImpl
extends ExtendedBehaviourServiceImpl
implements ExtendedActivityService {
    private Logger log = Logger.getLogger(ExtendedActivityServiceImpl.class.getName());
    private List<ExtendedActivityConfiguration> extendedActivitiesInits = Collections.synchronizedList(new ArrayList());
    private ExtendedActivityConfigurationListReader reader;
    private ExtendedActivityConfigurationException initEx = null;

    public ExtendedActivityServiceImpl(Engine engine) {
        super(engine);
        try {
            this.reader = new ExtendedActivityConfigurationListReaderImpl();
        }
        catch (ExtendedActivityConfigurationException extendedActivityConfigurationException) {
            this.initEx = extendedActivityConfigurationException;
        }
    }

    public void run() {
        try {
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.severe("BPELError in auto trash service: " + exception.getMessage());
        }
    }

    @Override
    public ExtendedActivityConfigurationList loadExtendedActivitiesConfigure(URL uRL) throws ExtendedActivityConfigurationException {
        ExtendedActivityConfigurationList extendedActivityConfigurationList = null;
        if (uRL == null) {
            throw new ExtendedActivityConfigurationException("url cannot be null!!!");
        }
        if (this.initEx != null) {
            throw this.initEx;
        }
        try {
            extendedActivityConfigurationList = this.reader.read(uRL.toURI());
            this.extendedActivitiesInits.addAll(extendedActivityConfigurationList.getExtendedActivityConf());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ExtendedActivityConfigurationException((Throwable)uRISyntaxException);
        }
        return extendedActivityConfigurationList;
    }

    @Override
    public List<ExtendedActivityConfiguration> getAllExtendedActivitiesInit() {
        return this.extendedActivitiesInits;
    }

    @Override
    public ExtendedActivityConfiguration findExtendedActivity(QName qName) {
        ExtendedActivityConfiguration extendedActivityConfiguration = null;
        for (ExtendedActivityConfiguration extendedActivityConfiguration2 : this.extendedActivitiesInits) {
            if (!extendedActivityConfiguration2.getTag().getLocalPart().equals(qName.getLocalPart()) || !extendedActivityConfiguration2.getTag().getNamespaceURI().equals(qName.getNamespaceURI())) continue;
            extendedActivityConfiguration = extendedActivityConfiguration2;
            break;
        }
        return extendedActivityConfiguration;
    }

    @Override
    public List<ExtendedActivityConfigurationList> getExtendedActivitiesConfiguresInJar(URL uRL) throws ExtendedActivityConfigurationException {
        ArrayList<ExtendedActivityConfigurationList> arrayList = new ArrayList<ExtendedActivityConfigurationList>();
        try {
            this.getExtendedBehaviourInJar(uRL);
            List list = (List)this.classLoader.getResources().get("xml");
            if (list != null) {
                for (String string : list) {
                    URL uRL2 = this.classLoader.getResource(string);
                    if (uRL2 == null) continue;
                    try {
                        arrayList.add(this.loadExtendedActivitiesConfigure(uRL2));
                    }
                    catch (ExtendedActivityConfigurationException extendedActivityConfigurationException) {}
                }
            }
            List list2 = this.getClassInJar(this.classLoader, ExtendedActivity.class);
        }
        catch (JarException jarException) {
            throw new ExtendedActivityConfigurationException((Throwable)jarException);
        }
        return arrayList;
    }
}

