/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Sources;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Targets;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extensions;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELWriter;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELIntVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLinks;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariables;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.extension.ExtensionActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.correlation.CorrelationSetImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.extension.ExtensionsImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.fault.FaultHandlersImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink.PartnerLinkImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELElementVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELIntVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports.ImportImpl;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Role;
import org.w3c.dom.Element;

@Scope(value="COMPOSITE")
@Service(value={BPELProcess.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class BPELProcessImpl
extends BPELElementImpl<TProcess>
implements BPELProcess {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(BPELProcessImpl.class.getName());
    private final URI baseURI;
    private static BPELWriter writer = null;
    private static BPELException writerEx = null;
    private static BPELReader reader = null;
    private static BPELException readerEx = null;
    protected NamespaceMapperImpl namespaceContext;
    private final Descriptions descriptions;
    private Activity activity;
    private Extensions extensions;
    private final List<BPELVariable> variables = new ArrayList<BPELVariable>();
    private final List<PartnerLink> partnerLinks = new ArrayList<PartnerLink>();
    private final List<CorrelationSet> correlationsets = new ArrayList<CorrelationSet>();
    private FaultHandlers faultHandlers = null;

    static {
        BPELFactory factory = null;
        factory = BPELFactoryImpl.getInstance();
        if (factory != null) {
            try {
                writer = factory.newBPELWriter();
            }
            catch (BPELException e) {
                writerEx = e;
            }
            try {
                reader = factory.newBPELReader();
            }
            catch (BPELException e) {
                readerEx = e;
            }
        }
    }

    public static BPELWriter getWriter() throws BPELException {
        if (writerEx != null) {
            throw writerEx;
        }
        return writer;
    }

    public static BPELReader getReader() throws BPELException {
        if (readerEx != null) {
            throw readerEx;
        }
        return reader;
    }

    public BPELProcessImpl(URI baseURI, TProcess process, NamespaceMapperImpl context, Map<BPELReader.FeatureConstants, Object> features) {
        super(Constants._Process_QNAME, (Object)process, null);
        this.baseURI = baseURI;
        try {
            BPELProcessImpl.getWriter();
        }
        catch (BPELException e) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this, new BPELException("In process " + this.getName() + " => " + e.getMessage(), (Throwable)e)));
        }
        try {
            BPELProcessImpl.getReader();
        }
        catch (BPELException e) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this, new BPELException("In process " + this.getName() + " => " + e.getMessage(), (Throwable)e)));
        }
        this.namespaceContext = context;
        ArrayList<ImportImpl> imports = new ArrayList<ImportImpl>();
        if (((TProcess)this.model).getImport() != null && ((TProcess)this.model).getImport().size() > 0) {
            for (TImport impt : ((TProcess)this.model).getImport()) {
                imports.add(new ImportImpl(impt, (BPELElement)this));
            }
        }
        this.descriptions = new Descriptions(((TProcess)this.model).getTargetNamespace(), ((TProcess)this.model).getName(), imports);
        if (((TProcess)this.model).getExtensions() != null && ((TProcess)this.model).getExtensions().getExtension().size() > 0) {
            this.extensions = new ExtensionsImpl(((TProcess)this.model).getExtensions(), (BPELElement)this);
        }
        if (((TProcess)this.model).getPartnerLinks() != null && ((TProcess)this.model).getPartnerLinks().getPartnerLink() != null && ((TProcess)this.model).getPartnerLinks().getPartnerLink().size() > 0) {
            for (TPartnerLink partner : ((TProcess)this.model).getPartnerLinks().getPartnerLink()) {
                this.partnerLinks.add(new PartnerLinkImpl(partner, ((TProcess)this.model).getPartnerLinks(), (BPELElement)this));
            }
        }
        try {
            this.variables.addAll(ScopeImpl.extractVariablesInModel(((TProcess)this.model).getVariables(), (BPELElement)this));
        }
        catch (BPELException e) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this, new BPELException("In process " + this.getName() + " => " + e.getMessage(), (Throwable)e)));
        }
        if (((TProcess)this.model).getFaultHandlers() != null) {
            this.faultHandlers = new FaultHandlersImpl(((TProcess)this.model).getFaultHandlers(), this);
        }
        try {
            this.correlationsets.addAll(CorrelationSetImpl.extractCorrelationSetsInModel(((TProcess)this.model).getCorrelationSets(), (BPELElement)this));
        }
        catch (BPELException e) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this, new BPELException("In process " + this.getName() + " => " + e.getMessage(), (Throwable)e)));
        }
        try {
            this.activity = ActivityImpl.analyzeProcess((TProcess)this.model, this);
            if (this.activity == null && ((TProcess)this.model).getExtensionActivity() != null) {
                this.activity = new ExtensionActivityImpl(((TProcess)this.model).getExtensionActivity(), (BPELElement)this);
            }
        }
        catch (BPELException e) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this, new BPELException("In process " + this.getName() + " => " + e.getMessage(), (Throwable)e)));
        }
    }

    public URI getDocumentBaseURI() {
        URI res = null;
        res = URI.create(this.baseURI.toString().substring(0, this.baseURI.toString().lastIndexOf("/") + 1));
        return res;
    }

    public String getName() {
        return ((TProcess)this.model).getName();
    }

    public void setName(String name) {
        ((TProcess)this.model).setName(name);
    }

    public String getDescription() {
        String res = null;
        try {
            res = BPELProcessImpl.getWriter().writeBPEL((BPELProcess)this);
        }
        catch (BPELException bPELException) {
            // empty catch block
        }
        return res;
    }

    public List<Element> getOtherElements() throws XmlException {
        throw new XmlException("Not yet implemented");
    }

    public Map<QName, String> getOtherAttributes() throws XmlException {
        return ((TProcess)this.model).getOtherAttributes();
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Descriptions getImports() {
        return this.descriptions;
    }

    public void addImport(Import impt) {
        if (impt != null) {
            this.descriptions.addImport(impt);
            ((TProcess)this.model).getImport().add((TImport)((AbstractSchemaElementImpl)impt).getModel());
        }
    }

    public void removeImport(Import impt) {
        if (impt != null) {
            this.descriptions.removeImport(impt);
            ((TProcess)this.model).getImport().remove((TImport)((AbstractSchemaElementImpl)impt).getModel());
        }
    }

    public QName getQName() {
        QName res = null;
        if (((TProcess)this.model).getName() != null) {
            res = new QName(((TProcess)this.model).getTargetNamespace(), ((TProcess)this.model).getName());
        }
        return res;
    }

    public Sources getSources() {
        return null;
    }

    public boolean getSuppressJoinFailure() {
        return false;
    }

    public Targets getTargets() {
        return null;
    }

    public void addVariable(BPELVariable variable) {
        this.variables.add(variable);
        ((TProcess)this.model).getVariables().getVariable().add((TVariable)((AbstractSchemaElementImpl)variable).getModel());
    }

    public List<BPELVariable> getVariables() {
        return this.variables;
    }

    public NamespaceMapperImpl getNamespaceContext() {
        return this.namespaceContext;
    }

    public PartnerLink getPartnerLink(String name) {
        PartnerLink res = null;
        for (PartnerLink partner : this.partnerLinks) {
            if (!partner.getName().equals(name)) continue;
            res = partner;
            break;
        }
        return res;
    }

    public List<PartnerLink> getPartnerLinks() {
        return this.partnerLinks;
    }

    public CorrelationSet getCorrelationSet(String name) {
        CorrelationSet res = null;
        for (CorrelationSet corr : this.correlationsets) {
            if (!corr.getName().equals(name)) continue;
            res = corr;
            break;
        }
        return res;
    }

    public List<CorrelationSet> getCorrelationSets() {
        return this.correlationsets;
    }

    public FaultHandlers getFaultHandlers() {
        return this.faultHandlers;
    }

    public BPELVariable findVariable(QName name) {
        return ScopeImpl.findVariable(name, this.variables, null);
    }

    public PartnerLink findPartnerLink(String name) {
        PartnerLink res = null;
        for (PartnerLink p : this.partnerLinks) {
            if (!p.getName().equals(name)) continue;
            res = p;
            break;
        }
        return res;
    }

    public String getTargetNamespace() {
        return ((TProcess)this.model).getTargetNamespace();
    }

    public void setTargetNamespace(String ns) {
        ((TProcess)this.model).setTargetNamespace(ns);
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public void setActivity(Activity activity) throws BPELException {
        this.activity = activity;
        try {
            ActivityImpl.setActivityToProcess(activity, this);
        }
        catch (BPELException e) {
            throw new BPELException((Throwable)e);
        }
    }

    public PartnerLink createPartnerLink() {
        TPartnerLinks partners = ((TProcess)this.model).getPartnerLinks();
        if (partners == null) {
            partners = new TPartnerLinks();
            ((TProcess)this.model).setPartnerLinks(partners);
        }
        TPartnerLink tpartner = new TPartnerLink();
        ((TProcess)this.model).getPartnerLinks().getPartnerLink().add(tpartner);
        PartnerLinkImpl partner = new PartnerLinkImpl(tpartner, ((TProcess)this.model).getPartnerLinks(), (BPELElement)this);
        this.getPartnerLinks().add(partner);
        return partner;
    }

    public BPELIntVariable createBPELIntVariable(String varName, QName e) {
        TVariable tvar = new TVariable();
        tvar.setName(varName);
        tvar.setType(e);
        TVariables tvars = ((TProcess)this.model).getVariables();
        if (tvars == null) {
            tvars = new TVariables();
            ((TProcess)this.model).setVariables(tvars);
        }
        ((TProcess)this.model).getVariables().getVariable().add(tvar);
        BPELIntVariableImpl var = new BPELIntVariableImpl(tvar, ((TProcess)this.model).getVariables(), (BPELElement)this);
        return var;
    }

    public BPELElementVariable createBPELElementVariable(String varName, QName e, BPELElementVariable.VariableType varType) {
        TVariable tvar = new TVariable();
        tvar.setName(varName);
        switch (varType) {
            case MESSAGE: {
                tvar.setMessageType(e);
                break;
            }
            case ELEMENT: {
                tvar.setElement(e);
                break;
            }
            case TYPE: {
                tvar.setType(e);
            }
        }
        TVariables tvars = ((TProcess)this.model).getVariables();
        if (tvars == null) {
            tvars = new TVariables();
            ((TProcess)this.model).setVariables(tvars);
        }
        BPELElementVariableImpl var = new BPELElementVariableImpl(tvar, ((TProcess)this.model).getVariables(), (BPELElement)this);
        this.addVariable((BPELVariable)var);
        return var;
    }

    public List<Interface> getProcessInterfaces() {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        for (PartnerLink partnerLink : this.partnerLinks) {
            if (partnerLink.getMyRole() == null) continue;
            Role myRole = this.getImports().getPartnerLinkType(partnerLink.getPartnerLinkType()).getRole(partnerLink.getMyRole());
            assert (myRole != null);
            interfaces.add(this.getImports().findInterface(myRole.getInterfaceQName()));
        }
        return interfaces;
    }
}

