/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ProcessValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Info;

public class ProcessValidatorImpl
implements ProcessValidator {
    private BPELProcess process = null;

    public ProcessValidatorImpl(BPELProcess process) {
        this.process = process;
    }

    public void validate() {
        TProcess tprocess;
        if (this.process.getName() == null || this.process.getName().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => the name of process cannot be null or empty")));
        }
        if (this.process.getTargetNamespace() == null || this.process.getTargetNamespace().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => the targetNamespace of process cannot be null or empty")));
        }
        if ((tprocess = (TProcess)((BPELElementImpl)this.process).getModel()).getSuppressJoinFailure() != null) {
            BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.process, "In process => [BPEL engine restriction] Sorry, but the suppressJoinFailure attribute is ignored for the moment"));
        }
        if (tprocess.getExitOnStandardFault() != null) {
            BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.process, "In process => [BPEL engine restriction] Sorry, but the exitOnStandardFault attribute is ignored for the moment"));
        }
        if (tprocess.getPartnerLinks() == null || tprocess.getPartnerLinks().getPartnerLink() == null || tprocess.getPartnerLinks().getPartnerLink().size() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => A process MUST have at less one partnerLink")));
        }
        if (tprocess.getVariables() == null || tprocess.getVariables().getVariable() == null || tprocess.getVariables().getVariable().size() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => A process MUST have at less one variable")));
        }
        if (tprocess.getPartnerLinks() != null && tprocess.getPartnerLinks().getPartnerLink() != null && tprocess.getPartnerLinks().getPartnerLink().size() > 0) {
            boolean myRole = false;
            for (TPartnerLink pl : tprocess.getPartnerLinks().getPartnerLink()) {
                if (pl.getMyRole() == null || pl.getMyRole().trim().length() <= 0) continue;
                myRole = true;
            }
            if (!myRole) {
                BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.process, "In process => [BPEL engine restriction] A process MUST have at less one partnerLink with a myRole attribute"));
                BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => [BPEL engine restriction] A process MUST have at less one partnerLink with a myRole attribute")));
            }
        }
        if (tprocess.getMessageExchanges() != null && tprocess.getMessageExchanges().getMessageExchange().size() > 0) {
            BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.process, "In process => [BPEL engine restriction] Sorry, but the messageExchanges are not supported for the moment"));
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => [BPEL engine restriction] Sorry, but the extensions are not supported for the moment")));
        }
        if (tprocess.getEventHandlers() != null && (tprocess.getEventHandlers().getOnEvent().size() > 0 || tprocess.getEventHandlers().getOnAlarm().size() > 0)) {
            BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.process, "In process => [BPEL engine restriction] Sorry, but the eventHandler are not supported for the moment"));
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => [BPEL engine restriction] Sorry, but the extensions are not supported for the moment")));
        }
    }
}

