/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.test.examples.activity.pick;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.DefaultBPELMessageConverter;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.Compiler;
import com.ebmwebsourcing.easyviper.environment.test.env.ExecutionEnvironmentTestFactory;
import com.ebmwebsourcing.easyviper.environment.test.env.TestSenderImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.LogManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PickProcessTest {
    private static final int timeout = 30000;

    @BeforeClass
    public static void init() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("logger.properties");
        try {
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @AfterClass
    public static void tearDown() {
        LogManager.getLogManager().reset();
    }

    @Test
    public void testPickTriggeredByAlarm() throws CoreException, URISyntaxException, BPELException, InterruptedException {
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
        Core core = BPELFactoryImpl.getInstance().newBPELEngine(DefaultBPELMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
        env.setCore(core);
        Compiler compiler = core.getModel().getCompiler();
        Process proc = compiler.compile(compiler.validate(new URI("./src/test/resources/com/ebmwebsourcing/easybpel/model/bpel/test/examples/activity/pick/pickProcessAlarm.bpel")));
        long start = System.currentTimeMillis();
        proc.run();
        while (!proc.getParentExecution().getState().equals((Object)Execution.State.ENDED)) {
            if (System.currentTimeMillis() - start > 30000L) {
                Assert.fail((String)("TIMED OUT " + (System.currentTimeMillis() - start) + "  " + proc.getParentExecution().getState()));
            }
            Thread.sleep(100L);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println(String.valueOf(duration));
        Assert.assertTrue((String)String.valueOf(duration), (duration > 2000L ? 1 : 0) != 0);
        Assert.assertEquals((Object)"node_supporting_main", (Object)proc.getParentExecution().getCurrentTarget().getName());
    }
}

