/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;

import org.apache.commons.lang.NotImplementedException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELStringExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ParseException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;


public class BPELStringExpressionImpl extends BPELExpressionImpl<String> implements BPELStringExpression {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(BPELStringExpressionImpl.class.getName());

	private final BPELProcess bpeldefinition;


	public BPELStringExpressionImpl(final TExpression model,
			final BPELElement parent) throws XPathExpressionException {
		super(model, parent);
		this.bpeldefinition = ScopeUtil.getProcess(parent);
	}

	public URI getExpressionLanguage() {
		URI res = null;
		if((this.model != null) && (this.model.getExpressionLanguage() != null)) {
			res = URI.create(this.model.getExpressionLanguage());
		} 
		return res;
	}

	public void setExpressionLanguage(final URI language) {
		this.model.setExpressionLanguage(language.toString());
	}

	public String getContent() {
		String content = null;
		if((this.model.getContent() != null) && (this.model.getContent().size() > 0)) {
			content = this.model.getContent().get(0).toString();
		}
		return content;
	}

	public void setContent(final String arg0) {
		throw new NotImplementedException();
	}

	public String evaluate(final Scope scope) throws CoreException {
		String res = null;
		String stringExpression = "";


		if(this.getContent() != null) {
			stringExpression = this.getContent();
		}
		try {
			this.log.finest("string expression to evaluate: " + stringExpression);
//			final InputStream input = new ByteArrayInputStream(stringExpression.getBytes());
			final ExpressionAnalyzer analyzer = new ExpressionAnalyzer(stringExpression);
			final ASTStart n = analyzer.Start();
			final ExpressionVisitor v = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
			if(!this.log.getName().equals(BPELStringExpressionImpl.class.getName())) {
				((ExpressionDumpVisitor)v).setLog(this.log);
			}
			final org.jdom.Element result = n.jjtAccept(v, null);
			if(result.getChildren() == null || result.getChildren().size() == 0) {
				res = result.getText();
			} else {
				res = new XMLOutputter(Format.getPrettyFormat()).outputString(result);
			}


		} catch (final ParseException e) {
			throw new CoreException("Impossible to evaluate expression: " + stringExpression, e);
		}


		return res;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

	public Expression<String, String> copypaste() {
		BPELStringExpression exp = null;
		try {
			exp = new BPELStringExpressionImpl(this.getModel(), (BPELElement) this.getParent());
		} catch (XPathExpressionException e) {
			// do nothing
		}
		return exp;
	}

	public void addOtherElements(Element elmt) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

}
