/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl.function;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Element;
import org.jdom.Namespace;
import org.ow2.easywsdl.schema.impl.Constants;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.AbstractBPELFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.GetVariablePropertyFunction;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class GetVariablePropertyFunctionImpl extends AbstractBPELFunction<Element> implements GetVariablePropertyFunction {

	private static Logger log = Logger.getLogger(GetVariablePropertyFunctionImpl.class.getName());


	private final String variable;

	private final String property;

	private final Scope scope;

	public GetVariablePropertyFunctionImpl(final String ns, final String variable, final String property, final Scope scope) throws XPathExpressionException {
		super(ns);
		this.variable = variable;
		this.property = property;
		this.scope = scope;
	}

	public Element process() throws XPathExpressionException {
		Element res = null;
		try {
			if( (this.variable == null) || (this.property == null) ) {
				throw new XPathExpressionException(
						"Wrong number of argument for the bpws:getVariableProperty function.");
			}
			
			org.jdom.Document doc = new org.jdom.Document(res);
			// find variable
			if("process".equals(this.variable)) {
				com.ebmwebsourcing.easyviper.core.api.engine.Process process = this.scope.getProcess();
				if("name".equals(this.property)) {
					res = new Element("value");
			        res.setAttribute("type", "xsd:string");
			        res.addNamespaceDeclaration(Namespace.getNamespace("xsd",
			                Constants.SCHEMA_NAMESPACE));

					res.setText(QName.valueOf(process.getName()).getLocalPart());
				} else {
					throw new XPathExpressionException(
							"This property is unknown of the variable 'process': " + this.property);
				}
			} else if("env".equals(this.variable)) {
				com.ebmwebsourcing.easyviper.core.api.engine.Process process = this.scope.getProcess();
				if("host".equals(this.property)) {
					res = new Element("value");
			        res.setAttribute("type", "xsd:string");
			        res.addNamespaceDeclaration(Namespace.getNamespace("xsd",
			                Constants.SCHEMA_NAMESPACE));

					res.setText(process.getEngine().getCore().getExternalEnvironment().getHost());
				} else if("port".equals(this.property)) {
					res = new Element("value");
			        res.setAttribute("type", "xsd:string");
			        res.addNamespaceDeclaration(Namespace.getNamespace("xsd",
			                Constants.SCHEMA_NAMESPACE));

					res.setText(process.getEngine().getCore().getExternalEnvironment().getPort());
				} else {
					throw new XPathExpressionException(
							"This property is unknown of the variable 'process': " + this.property);
				}
			} else {
				throw new XPathExpressionException(
						"This variable is unknown of this engine: " + this.variable);
			}
		} catch (CoreException e) {
			throw new XPathExpressionException(e);
		}
		return res;
	}


}
