/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.api.type;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.OutputSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithDataOutput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithDataOutputAssociation;



public interface TCatchEvent extends TEvent, WithDataOutputAssociation, WithDataOutput {

	OutputSet getOutputSet();

	void setOutputSet(OutputSet value);

	boolean hasOutputSet();

	void addEventDefinition(EventDefinition eventDef);

	void removeEventDefinition(EventDefinition eventDef);

	EventDefinition[] getEventDefinition() ;

	boolean hasEventDefinition() ;

	void unsetEventDefinition();

	QName[] getEventDefinitionRef() ;

	boolean hasEventDefinitionRef();

	void unsetEventDefinitionRef();

	void addEventDefinitionRef(QName ref);

	void removeEventDefinitionRef(QName ref);

	boolean isParallelMultiple();

	void setParallelMultiple(boolean value) ;

	boolean hasParallelMultiple() ;

	void unsetParallelMultiple();

}
