/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.api.type;

import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.with.WithId;
import com.ebmwebsourcing.easybox.api.with.WithName;
import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import com.ebmwebsourcing.easybox.api.with.WithTargetNamespace;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Choreography;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataStore;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EndPoint;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Error;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Escalation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Extension;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerEntity;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RelationShip;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RootElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Signal;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNDiagram;
import com.ebmwebsourcing.easyschema10.api.element.Element;

public interface TDefinitions extends XmlObject, WithId, WithOtherAttributes,
		WithName, WithTargetNamespace {

	Import[] getImports();
	
	Import getImport(String namespace);

	boolean hasImport();

	void unsetImport();

	void addImport(Import i);

	void removeImport(Import i);
	
	Element findImportedElement(QName eltQName) throws BPMNException;
	
	Map<String,String> findImportPrefixes();
	

	Extension[] getExtension();

	boolean hasExtension();

	void unsetExtension();
	
	void addExtension(Extension e);
	
	void removeExtension(Extension e);
	
	
	void addRootElement(RootElement e);
	
	void removeRootElement(RootElement e);

	RootElement[] getRootElement();

	boolean hasRootElement();

	void unsetRootElement();
	

	Process[] getProcesses();

	Message[] getMessages();
	
	Message getMessage(String msgName);

	PartnerRole[] getPartnerRoles();

	PartnerEntity[] getPartnerEntities();

	ItemDefinition[] getItemDefinitions();

	Collaboration[] getCollaborations();

	DataStore[] getDataStores();
	
	Choreography[] getChoreographies();
	
	Error[] getErrors();

	EndPoint[] getEndPoints();
	
	EndPoint getEndPoint(QName qname);

	Signal[] getSignals();
	
	Escalation[] getEscalations();
	
	Interface[] getInterfaces();


	
	BPMNDiagram[] getBPMNDiagram();

	boolean hasBPMNDiagram();

	void unsetBPMNDiagram();

	void addBPMNDiagram(BPMNDiagram d);

	void removeBPMNDiagram(BPMNDiagram d);

	
	RelationShip[] getRelationship();

	boolean hasRelationship();

	void unsetRelationship();

	
	boolean hasId();

	String getExpressionLanguage();

	void setExpressionLanguage(String value);

	boolean hasExpressionLanguage();

	String getTypeLanguage();

	void setTypeLanguage(String value);

	boolean hasTypeLanguage();

	String getExporter();

	void setExporter(String value);

	boolean hasExporter();

	String getExporterVersion();

	void setExporterVersion(String value);

	boolean hasExporterVersion();

}
