/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/

package com.ebmwebsourcing.easybpmn.bpmn20.api.type;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CorrelationSubscription;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ResourceRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithArtifact;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithAuditingAndMonitoring;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithFlowElements;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithLaneSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithProperty;

public interface TProcess extends TCallableElement, WithFlowElements, WithProperty, WithArtifact,
        WithAuditingAndMonitoring, WithLaneSet {

    ResourceRole[] getResourceRole();

    boolean hasResourceRole();

    void unsetResourceRole();

    CorrelationSubscription[] getCorrelationSubscription();

    boolean hasCorrelationSubscription();

    void unsetCorrelationSubscription();

    QName[] getSupports();

    boolean hasSupports();

    void unsetSupports();

    void addSupport(QName support);

    void removeSupport(QName support);

    TProcessType getProcessType();

    void setProcessType(TProcessType value);

    boolean hasProcessType();

    boolean isIsClosed();

    void setIsClosed(boolean value);

    boolean hasIsClosed();

    void unsetIsClosed();

    boolean isIsExecutable();

    void setIsExecutable(boolean value);

    boolean hasIsExecutable();

    void unsetIsExecutable();

    QName getDefinitionalCollaborationRef();

    void setDefinitionalCollaborationRef(QName value);

    boolean hasDefinitionalCollaborationRef();

}
