/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn20.api;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TBaseElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TFlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithFlowElements;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

public class DefinitionsHelper {
    private static XmlObjectXPathEvaluator xpe;

    public static <T extends XmlObject> T findBPMNObject(Definitions defs, QName ref, Class<T> wantedClass) throws BPMNException {
        if (ref.getNamespaceURI() == null || ref.getNamespaceURI().isEmpty()) {
            return DefinitionsHelper.findObjectInDefinitions(defs, ref.getLocalPart(), wantedClass);
        }
        Import impt = defs.getImport(ref.getNamespaceURI());
        if (impt != null && impt.isBPMN20Import()) {
            Definitions importedDefs = impt.getBPMNDefinitions();
            return DefinitionsHelper.findObjectInDefinitions(importedDefs, ref.getLocalPart(), wantedClass);
        }
        throw new BPMNException("No bpmn element has been found for this QName : " + ref);
    }

    public static <T extends XmlObject> T findObjectInDefinitions(Definitions defs, String id, Class<T> wantedClass) throws BPMNException {
        if (xpe == null) {
            xpe = defs.getXmlContext().createXPathEvaluator();
        }
        try {
            return (T)((XmlObject)xpe.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + id + "']", wantedClass));
        }
        catch (XPathExpressionException e) {
            throw new BPMNException(e);
        }
    }

    public static Process getProcess(FlowElement fe, Definitions defs) {
        for (Process p : defs.getProcesses()) {
            for (FlowElement elt : p.getFlowElement()) {
                if (!fe.equals(elt)) continue;
                return p;
            }
        }
        return null;
    }

    public static SequenceFlow getSequenceFlow(Process proc, String sourceId, String targetId) {
        for (SequenceFlow sf : proc.getFlowElementsByClass(SequenceFlow.class)) {
            if (!sf.getSourceRef().getId().equals(sourceId) || !sf.getTargetRef().getId().equals(targetId)) continue;
            return sf;
        }
        return null;
    }

    public static Definitions getParentDefinitions(TBaseElement be) {
        return DefinitionsHelper.getParentDefinitions(be.getXmlObjectParent());
    }

    private static Definitions getParentDefinitions(XmlObject xo) {
        if (xo == null) {
            return null;
        }
        if (xo instanceof Definitions) {
            return (Definitions)xo;
        }
        return DefinitionsHelper.getParentDefinitions(xo.getXmlObjectParent());
    }

    public static WithFlowElements getParentContainer(TFlowElement fe) {
        return DefinitionsHelper.getParentContainer(fe.getXmlObjectParent());
    }

    private static WithFlowElements getParentContainer(XmlObject xo) {
        if (xo == null) {
            return null;
        }
        if (xo instanceof WithFlowElements) {
            return (WithFlowElements)xo;
        }
        return DefinitionsHelper.getParentContainer(xo.getXmlObjectParent());
    }
}

