/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.InputOutputBinding;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.InputOutputSpecification;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TCallableElement;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCallableElement;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTInputOutputBinding;

class TCallableElementImpl extends
		AbstractTRootElementImpl<EJaxbTCallableElement> implements
		TCallableElement {

	protected TCallableElementImpl(XmlContext xmlContext,
			EJaxbTCallableElement jaxbModel) {
		super(xmlContext, jaxbModel);
	}
	
	@Override
	protected Class<? extends EJaxbTCallableElement> getCompliantModelClass() {
		return EJaxbTCallableElement.class;
	}


	@Override
	public QName[] getSupportedInterfaceRef() {
		List<QName> l = this.getModelObject().getSupportedInterfaceRef();
		return l.toArray(new QName[l.size()]);
	}
	
	@Override
    public void addSupportedInterfaceRef(QName ref) {
	    getModelObject().getSupportedInterfaceRef().add(ref);
    }

    @Override
    public void removeSupportedInterfaceRef(QName ref) {
        getModelObject().getSupportedInterfaceRef().remove(ref);
    }

	@Override
	public boolean hasSupportedInterfaceRef() {
		return this.getModelObject().isSetSupportedInterfaceRef();
	}

	@Override
	public void unsetSupportedInterfaceRef() {
		this.getModelObject().unsetSupportedInterfaceRef();

	}

	@Override
	public InputOutputSpecification getIoSpecification() {
	    if(this.getModelObject().getIoSpecification()==null){
            return null;
        }
		return this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getIoSpecification(),
						InputOutputSpecificationImpl.class);
	}

    @Override
    public void setIoSpecification(InputOutputSpecification value) {
        if (value != null) {
            this.getModelObject().setIoSpecification(
                    ((InputOutputSpecificationImpl) value).getModelObject());
        } else {
            this.getModelObject().setIoSpecification(null);
        }
    }

	@Override
	public boolean hasIoSpecification() {
		return this.getModelObject().isSetIoSpecification();
	}

	@Override
	public InputOutputBinding[] getIoBinding() {
		return createChildrenArray(getModelObject().getIoBinding(),
				EJaxbTInputOutputBinding.class, ANY_QNAME,
				InputOutputBindingImpl.class);

	}

	@Override
	public boolean hasIoBinding() {
		return this.getModelObject().isSetIoBinding();
	}

	@Override
	public void unsetIoBinding() {
		this.getModelObject().unsetIoBinding();
	}
	
	@Override
    public void addIoBinding(InputOutputBinding iobinding) {
	    addToChildren(getModelObject().getIoBinding(), iobinding);
    }

    @Override
    public void removeIoBinding(InputOutputBinding iobinding) {
        removeFromChildren(getModelObject().getIoBinding(), iobinding);
    }

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);

	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

}
