/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TCorrelationPropertyBinding;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCorrelationPropertyBinding;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFormalExpression;

class TCorrelationPropertyBindingImpl extends
		AbstractTBaseElementImpl<EJaxbTCorrelationPropertyBinding> implements
		TCorrelationPropertyBinding {

	protected TCorrelationPropertyBindingImpl(XmlContext xmlContext,
			EJaxbTCorrelationPropertyBinding jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public Expression getDataPath() {
		return this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getDataPath(),
						ExpressionImpl.class);
	}

	@Override
	public void setDataPath(Expression value) {
		this.getModelObject().setDataPath((EJaxbTFormalExpression)((ExpressionImpl)value).getModelObject());
	}

	@Override
	public boolean hasDataPath() {
		return this.getModelObject().isSetDataPath();
	}

	@Override
	public QName getCorrelationPropertyRef() {
		return this.getModelObject().getCorrelationPropertyRef();
	}

	@Override
	public void setCorrelationPropertyRef(QName value) {
		this.getModelObject().setCorrelationPropertyRef(value);
	}

	@Override
	public boolean hasCorrelationPropertyRef() {
		return this.getModelObject().isSetCorrelationPropertyRef();
	}

	@Override
	protected Class<? extends EJaxbTCorrelationPropertyBinding> getCompliantModelClass() {
		return EJaxbTCorrelationPropertyBinding.class;
	}

}
