/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.Constants;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TEndPoint;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTEndPoint;

class TEndPointImpl extends AbstractTRootElementImpl<EJaxbTEndPoint> implements
TEndPoint {

	protected TEndPointImpl(XmlContext xmlContext, EJaxbTEndPoint jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTEndPoint> getCompliantModelClass() {
		return EJaxbTEndPoint.class;
	}

    @Override
    public QName getEndPointRef() {
        String value = this.getOtherAttribute(Constants.ENDPOINT_REF_ATTR_QNAME);
        if(value!=null) {
            Map<String, String> nsPrefixes = DefinitionsHelper.getParentDefinitions(this).findImportPrefixes();
            for(String nsURI : nsPrefixes.keySet()) {
                String prefix = nsPrefixes.get(nsURI)+":";
                if(value.startsWith(prefix)) {
                    return QName.valueOf(value.replace(prefix, "{"+nsURI+"}"));
                }
            }
            return QName.valueOf(value);
        }
        return null;
    }

    @Override
    public boolean hasEndPointRef() {
        return this.hasOtherAttribute(Constants.ENDPOINT_REF_ATTR_QNAME);
    }

    @Override
    public void setEndpointRef(QName ref) {
        if(ref==null) {
            this.removeOtherAttribute(Constants.ENDPOINT_REF_ATTR_QNAME);
        }
        else {
            this.addOtherAttribute(Constants.ENDPOINT_REF_ATTR_QNAME, ref.toString());
        }
    }

}
