/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BaseElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.LaneSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TLane;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTBaseElement;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFlowNode;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTLane;

public class TLaneImpl extends AbstractTBaseElementImpl<EJaxbTLane> implements
		TLane {

	protected TLaneImpl(XmlContext xmlContext, EJaxbTLane jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTLane> getCompliantModelClass() {
		return EJaxbTLane.class;
	}

	@Override
	public BaseElement getPartitionElement() {
		return (BaseElement)
				this.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getPartitionElement());
	}

	@SuppressWarnings("unchecked")
	@Override
	public void setPartitionElement(BaseElement value) {
		this.getModelObject().setPartitionElement(
				((AbstractTBaseElementImpl<? extends EJaxbTBaseElement>)value).getModelObject());
	}

	@Override
	public boolean hasPartitionElement() {
		return this.getModelObject().isSetPartitionElement();
	}

	@Override
	public FlowNode[] getFlowNodeRef() {
		XmlObject[] tab = createChildrenArray(getModelObject().getFlowNodeRef(), EJaxbTFlowNode.class, ANY_QNAME);
		FlowNode[] result = new FlowNode[tab.length];
		for(int i=0; i<tab.length; i++){
			result[i] = (FlowNode) tab[i];
		}
		return result;
	}
	
	@Override
	public void addFlowNodeRef(FlowNode fn) {
		addToChildren(getModelObject().getFlowNodeRef(), fn);
	}

	@Override
	public void removeFlowNodeRef(FlowNode fn) {
		removeFromChildren(getModelObject().getFlowNodeRef(), fn);
	}


	@Override
	public boolean hasFlowNodeRef() {
		return this.getModelObject().isSetFlowNodeRef();
	}

	@Override
	public void unsetFlowNodeRef() {
		this.getModelObject().unsetFlowNodeRef();
	}

	@Override
	public LaneSet getChildLaneSet() {
		if(this.getModelObject().getChildLaneSet()==null){
			return null;
		}
		return this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getChildLaneSet(), LaneSetImpl.class);
	}

	@Override
	public void setChildLaneSet(LaneSet value) {
		if(value!=null){
			this.getModelObject().setChildLaneSet(((LaneSetImpl)value).getModelObject());
		}
		else{
			this.getModelObject().setChildLaneSet(null);
		}
	}

	@Override
	public boolean hasChildLaneSet() {
		return this.getModelObject().isSetChildLaneSet();
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
	public QName getPartitionElementRef() {
		return this.getModelObject().getPartitionElementRef();
	}

	@Override
	public void setPartitionElementRef(QName value) {
		this.getModelObject().setPartitionElementRef(value);
	}

	@Override
	public boolean hasPartitionElementRef() {
		return this.getModelObject().isSetPartitionElementRef();
	}

}
