/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TTimerEventDefinition;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExpression;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTTimerEventDefinition;

class TTimerEventDefinitionImpl extends
		AbstractTEventDefinitionImpl<EJaxbTTimerEventDefinition> implements
		TTimerEventDefinition {

	protected TTimerEventDefinitionImpl(XmlContext xmlContext,
			EJaxbTTimerEventDefinition jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTTimerEventDefinition> getCompliantModelClass() {
		return EJaxbTTimerEventDefinition.class;
	}


	@Override
	public Expression getTimeDate() {
		if(this.getModelObject().getTimeDate()==null){
			return null;
		}
		return (Expression) this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getTimeDate());
	}

	@Override
	public void setTimeDate(Expression value) {
		if(value!=null){
			this.getModelObject().setTimeDate((EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
			this.getModelObject().setTimeCycle(null);
			this.getModelObject().setTimeDuration(null);
		}
		else{
			this.getModelObject().setTimeDate(null);
		}
	}

	@Override
	public boolean hasTimeDate() {
		return this.getModelObject().isSetTimeDate();
	}

	@Override
	public Expression getTimeDuration() {
		if(this.getModelObject().getTimeDuration()==null){
			return null;
		}
		return (Expression) this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getTimeDuration());
	}

	@Override
	public void setTimeDuration(Expression value) {
		if(value!=null){
			this.getModelObject().setTimeDuration((EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
			this.getModelObject().setTimeCycle(null);
			this.getModelObject().setTimeDate(null);
		}
		else{
			this.getModelObject().setTimeDuration(null);
		}
	}

	@Override
	public boolean hasTimeDuration() {
		return this.getModelObject().isSetTimeDuration();
	}

	@Override
	public Expression getTimeCycle() {
		if(this.getModelObject().getTimeCycle()==null){
			return null;
		}
		return (Expression) this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getTimeCycle());
	}

	@Override
	public void setTimeCycle(Expression value) {
		if(value!=null){
			this.getModelObject().setTimeCycle((EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
			this.getModelObject().setTimeDate(null);
			this.getModelObject().setTimeDuration(null);
		}
		else{
			this.getModelObject().setTimeCycle(null);
		}
	}

	@Override
	public boolean hasTimeCycle() {
		return this.getModelObject().isSetTimeCycle();
	}

}
