/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.lang.reflect.Constructor;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.Constants;

public final class XmlObjectSchemaBindingImpl extends
		AbstractXmlObjectSchemaBindingImpl {

	public String getOriginatingSchemaDir() {
		return "schema/bpmn20";
	}

	public String getOriginatingSchemaName() {
		return "bpmn20.xsd";
	}

	public Package getModelObjectPackage() {
		return easybox.org.omg.spec.bpmn._20100524.model.ObjectFactory.class
				.getPackage();
	}

	public String getOriginatingSchemaNamespaceURI() {
		return Constants.BPMN20_NS_URI;
	}

	@SuppressWarnings("unchecked")
	public Class<? extends XmlObject>[] getFactorableClasses() {
		List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();

		// element
		factorableClasses.add(AdHocSubProcessImpl.class);
		factorableClasses.add(AuditingImpl.class);
		factorableClasses.add(AssociationImpl.class);
		factorableClasses.add(AssignmentImpl.class);

		factorableClasses.add(BoundaryEventImpl.class);
		factorableClasses.add(BusinessRuleTaskImpl.class);

		factorableClasses.add(CallActivityImpl.class);
		factorableClasses.add(CallableElementImpl.class);
		factorableClasses.add(ChoreographyImpl.class);
		factorableClasses.add(CallChoreographyImpl.class);
		factorableClasses.add(CallConversationImpl.class);
		factorableClasses.add(CancelEventDefinitionImpl.class);
		factorableClasses.add(CategoryImpl.class);
		factorableClasses.add(CategoryValueImpl.class);
		factorableClasses.add(ChoreographyTaskImpl.class);
		factorableClasses.add(CollaborationImpl.class);
		factorableClasses.add(CompensateEventDefinitionImpl.class);
		factorableClasses.add(ComplexBehaviorDefinitionImpl.class);
		factorableClasses.add(ComplexGatewayImpl.class);
		factorableClasses.add(ConditionalEventDefinitionImpl.class);
		factorableClasses.add(ConversationImpl.class);
		factorableClasses.add(ConversationAssociationImpl.class);
		factorableClasses.add(ConversationLinkImpl.class);
		factorableClasses.add(CorrelationKeyImpl.class);
		factorableClasses.add(CorrelationPropertyImpl.class);
		factorableClasses.add(CorrelationPropertyBindingImpl.class);
		factorableClasses.add(CorrelationPropertyRetrievalExpressionImpl.class);
		factorableClasses.add(CorrelationSubscriptionImpl.class);

		factorableClasses.add(DataAssociationImpl.class);
		factorableClasses.add(DocumentationImpl.class);
		factorableClasses.add(DefinitionsImpl.class);
		factorableClasses.add(DataOutputImpl.class);
		factorableClasses.add(DataInputImpl.class);
		factorableClasses.add(DataInputAssociationImpl.class);
		factorableClasses.add(DataOutputAssociationImpl.class);
		factorableClasses.add(DataObjectImpl.class);
		factorableClasses.add(DataObjectReferenceImpl.class);
		factorableClasses.add(DataStateImpl.class);
		factorableClasses.add(DataStoreImpl.class);
		factorableClasses.add(DataStoreReferenceImpl.class);

		factorableClasses.add(EndEventImpl.class);
		factorableClasses.add(EndPointImpl.class);
		factorableClasses.add(ErrorImpl.class);
		factorableClasses.add(ErrorEventDefinitionImpl.class);
		factorableClasses.add(EscalationImpl.class);
		factorableClasses.add(EscalationEventDefinitionImpl.class);
		factorableClasses.add(EventBasedGatewayImpl.class);
		factorableClasses.add(ExclusiveGatewayImpl.class);
		factorableClasses.add(ExpressionImpl.class);
		factorableClasses.add(ExtensionImpl.class);
		factorableClasses.add(ExtensionElementsImpl.class);

		//factorableClasses.add(FormalExpressionImpl.class);

		factorableClasses.add(GlobalBusinessRuleTaskImpl.class);
		factorableClasses.add(GlobalChoreographyTaskImpl.class);
		factorableClasses.add(GlobalConversationImpl.class);
		factorableClasses.add(GlobalManualTaskImpl.class);
		factorableClasses.add(GlobalScriptTaskImpl.class);
		factorableClasses.add(GlobalTaskImpl.class);
		factorableClasses.add(GlobalUserTaskImpl.class);
		factorableClasses.add(GroupImpl.class);
		
		factorableClasses.add(HumanPerformerImpl.class);
		
		factorableClasses.add(ImplicitThrowEventImpl.class);
		factorableClasses.add(ImportImpl.class);
		factorableClasses.add(InclusiveGatewayImpl.class);
		factorableClasses.add(InputOutputBindingImpl.class);
		factorableClasses.add(InputOutputSpecificationImpl.class);
		factorableClasses.add(InputOutputSpecificationImpl.class);
		factorableClasses.add(InputSetImpl.class);
		factorableClasses.add(InterfaceImpl.class);
		factorableClasses.add(IntermediateCatchEventImpl.class);
		factorableClasses.add(IntermediateThrowEventImpl.class);
		factorableClasses.add(ItemDefinitionImpl.class); 
		
		factorableClasses.add(LaneImpl.class);
		factorableClasses.add(LaneSetImpl.class);
		factorableClasses.add(LinkEventDefinitionImpl.class);
		
		factorableClasses.add(ManualTaskImpl.class);
		factorableClasses.add(MessageImpl.class);
		factorableClasses.add(MessageEventDefinitionImpl.class); 
		factorableClasses.add(MessageFlowImpl.class);
		factorableClasses.add(MessageFlowAssociationImpl.class);
		factorableClasses.add(MonitoringImpl.class);
		factorableClasses.add(MultiInstanceLoopCharacteristicsImpl.class);
		
		factorableClasses.add(OperationImpl.class);
		factorableClasses.add(OutputSetImpl.class);
		
		factorableClasses.add(ParallelGatewayImpl.class);
		factorableClasses.add(ParticipantImpl.class); 
		factorableClasses.add(ParticipantAssociationImpl.class);
		factorableClasses.add(ParticipantMultiplicityImpl.class);
		factorableClasses.add(PartnerEntityImpl.class);
		factorableClasses.add(PartnerRoleImpl.class); 
		factorableClasses.add(PerformerImpl.class);
		factorableClasses.add(PotentialOwnerImpl.class);
		factorableClasses.add(ProcessImpl.class);
		factorableClasses.add(PropertyImpl.class); 
		
		factorableClasses.add(ReceiveTaskImpl.class);
		factorableClasses.add(RelationshipImpl.class); 
		factorableClasses.add(RenderingImpl.class); 
		factorableClasses.add(ResourceImpl.class); 
		factorableClasses.add(ResourceAssignmentExpressionImpl.class);
		factorableClasses.add(ResourceParameterImpl.class);
		factorableClasses.add(ResourceParameterBindingImpl.class);
		factorableClasses.add(ResourceRoleImpl.class); 
		
		factorableClasses.add(ScriptImpl.class);
		factorableClasses.add(ScriptTaskImpl.class);
		factorableClasses.add(SendTaskImpl.class);
		factorableClasses.add(SequenceFlowImpl.class); 
		factorableClasses.add(ServiceTaskImpl.class);
		factorableClasses.add(SignalImpl.class);
		factorableClasses.add(SignalEventDefinitionImpl.class); 
		factorableClasses.add(StandardLoopCharacteristicsImpl.class);
		factorableClasses.add(StartEventImpl.class);
		factorableClasses.add(SubChoreographyImpl.class);
		factorableClasses.add(SubConversationImpl.class);
		factorableClasses.add(SubProcessImpl.class);
		
		factorableClasses.add(TaskImpl.class);
		factorableClasses.add(TerminateEventDefinitionImpl.class); 
		factorableClasses.add(TextImpl.class);
		factorableClasses.add(TextAnnotationImpl.class);
		factorableClasses.add(TimerEventDefinitionImpl.class);  
		factorableClasses.add(TransactionImpl.class);  
		factorableClasses.add(UserTaskImpl.class);
		return factorableClasses.toArray(new Class[factorableClasses.size()]);
	}

	protected XmlObject doWrap(XmlContext xmlContext,
			Constructor<? extends XmlObject> xmlObjectImplConstructor,
			ModelObject ModelObjectObject) throws InstantiationException,
			IllegalAccessException, InvocationTargetException {
		return xmlObjectImplConstructor.newInstance(xmlContext,
				ModelObjectObject);
	}

	public String getOriginatingSchemaPreferredNamespacePrefix() {
		return "bpmn20";
	}

	@Override
	public String getName() {
		return "bpmn20-impl";
	}

}
