/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn20.api;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EndEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Lane;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.LaneSet;
import junit.framework.Assert;
import org.junit.Test;

public class LaneTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_NUMBER_FLOWNODE = "expectedNUmberOfFN";
    public static final String HAS_CHILD_LANESET = "hasChildLaneset";

    public LaneTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testFlowNodes() {
        Lane l = (Lane)this.newObjectUnderTest();
        if (this.hasTestData(EXPECTED_NUMBER_FLOWNODE)) {
            Assert.assertNotNull((Object)l.getFlowNodeRef());
            Assert.assertEquals((Object)this.getTestData(EXPECTED_NUMBER_FLOWNODE), (Object)l.getFlowNodeRef().length);
        }
        l.unsetFlowNodeRef();
        Assert.assertFalse((boolean)l.hasFlowNodeRef());
        EndEvent ee = (EndEvent)this.getXmlContext().getXmlObjectFactory().create(EndEvent.class);
        ee.setId("EEID");
        l.addFlowNodeRef((FlowNode)ee);
        Assert.assertTrue((boolean)l.hasFlowNodeRef());
        Assert.assertEquals((int)1, (int)l.getFlowNodeRef().length);
        Assert.assertEquals((Object)ee, (Object)l.getFlowNodeRef()[0]);
        Assert.assertEquals((String)ee.getId(), (String)l.getFlowNodeRef()[0].getId());
        l.removeFlowNodeRef((FlowNode)ee);
        Assert.assertFalse((boolean)l.hasFlowNodeRef());
        Assert.assertEquals((int)0, (int)l.getFlowNodeRef().length);
    }

    @Test
    public void testChildLaneset() {
        Lane l = (Lane)this.newObjectUnderTest();
        if (this.hasTestData(HAS_CHILD_LANESET)) {
            Assert.assertNotNull((Object)l.getChildLaneSet());
        }
        LaneSet ls = (LaneSet)this.getXmlContext().getXmlObjectFactory().create(LaneSet.class);
        ls.setId("EEID");
        l.setChildLaneSet(ls);
        Assert.assertTrue((boolean)l.hasChildLaneSet());
        Assert.assertEquals((Object)ls, (Object)l.getChildLaneSet());
        l.setChildLaneSet(null);
        Assert.assertFalse((boolean)l.hasChildLaneSet());
        Assert.assertNull((Object)l.getChildLaneSet());
    }
}

