/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Documentation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExtensionElements;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TBaseElementWithMixedContent;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTBaseElementWithMixedContent;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDocumentation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExtensionElements;

abstract class AbstractTBaseElementWithMixedContentImpl<Model extends EJaxbTBaseElementWithMixedContent>
extends AbstractJaxbXmlObjectImpl<Model> implements TBaseElementWithMixedContent  {

	protected AbstractTBaseElementWithMixedContentImpl(XmlContext xmlContext,Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}
	
	@Override
	public String getId() {
		return this.getModelObject().getId();
	}

	@Override
	public void setId(String value) {
		this.getModelObject().setId(value);
	}

	@Override
	public Map<QName, String> getOtherAttributes() {
		return this.getModelObject().getOtherAttributes();
	}
	
	@Override
	public void addOtherAttribute(QName arg0, String arg1) {
		this.getModelObject().getOtherAttributes().put(arg0, arg1);
	}

	@Override
	public void clearOtherAttributes() {
		this.getModelObject().getOtherAttributes().clear();
	}

	@Override
	public String getOtherAttribute(QName arg0) {
		return this.getModelObject().getOtherAttributes().get(arg0);
	}

	@Override
	public boolean hasOtherAttribute(QName arg0) {
		return this.getModelObject().getOtherAttributes().containsKey(arg0);
	}

	@Override
	public void removeOtherAttribute(QName arg0) {
		this.getModelObject().getOtherAttributes().remove(arg0);
	}

	@Override
	public String getTextContent(){
		for(Serializable s : getModelObject().getContent()){
			if(s instanceof String){
				return (String) s;
			}
		}
		return null;
	}
	
	@Override
	public void setTextContent(String text){
		int index = -1;
		for(int i=0; i<getModelObject().getContent().size(); i++){
			if(getModelObject().getContent().get(i) instanceof String){
				index = i;
				break;
			}
		}
		if(index==-1){
			getModelObject().getContent().add(text);
		}
		else{
			getModelObject().getContent().set(index, text);
		}
	}

	@Override
	public boolean hasTextContent(){
		for(Serializable s : getModelObject().getContent()){
			if(s instanceof String){
				return true;
			}
		}
		return false;
	}

	@Override
	public void unsetTextContent(){
		String string = null;
		for(Serializable s : getModelObject().getContent()){
			if(s instanceof String){
				string = (String) s;
				break;
			}
		}
		
		if(string!=null){
			getModelObject().getContent().remove(string);
		}
	}
	
	@Override
	public Documentation[] getDocumentations(){
		List<Documentation> l = new ArrayList<Documentation>();
		for(Serializable s : getModelObject().getContent()){
			if(s instanceof JAXBElement<?>){
				JAXBElement<?> e = (JAXBElement<?>) s;
				if(e.getValue() instanceof EJaxbTDocumentation){
					l.add((Documentation) getXmlContext().getXmlObjectFactory().wrap(e.getValue()));
				}
			}
		}
		return l.toArray(new Documentation[l.size()]);
	}
	
	@Override
	public boolean hasDocumentation(){
		for(Serializable s : getModelObject().getContent()){
			if(s instanceof JAXBElement<?>){
				JAXBElement<?> e = (JAXBElement<?>) s;
				if(e.getValue() instanceof EJaxbTDocumentation){
					return true;
				}
			}
		}
		return false;
	}
	
	@Override
	public void addDocumentation(Documentation doc){
		if(doc!=null){
			JAXBElement<EJaxbTDocumentation> e = 
				new JAXBElement<EJaxbTDocumentation>(Documentation.QNAME, EJaxbTDocumentation.class, ((DocumentationImpl)doc).getModelObject());
			getModelObject().getContent().add(e);
		}
	}
	
	@Override
	public void removeDocumentation(Documentation doc){
		if(doc==null){
			return;
		}
		EJaxbTDocumentation value = ((DocumentationImpl)doc).getModelObject();
		JAXBElement<?> je = null;
		for(Serializable s : getModelObject().getContent()){
			if(s instanceof JAXBElement<?>){
				JAXBElement<?> e = (JAXBElement<?>) s;
				if(e.getValue() instanceof EJaxbTDocumentation 
						&& ((EJaxbTDocumentation)e.getValue()).getId().equals(value.getId())){
					je = e;
					break;
				}
			}
		}
		if(je!=null){
			this.getModelObject().getContent().remove(je);
		}
	}
	
	@Override
	public ExtensionElements getExtensionElements(){
		for(Serializable s : getModelObject().getContent()){
			if(s instanceof JAXBElement<?>){
				JAXBElement<?> e = (JAXBElement<?>) s;
				if(e.getValue() instanceof EJaxbTExtensionElements){
					return (ExtensionElements) getXmlContext().getXmlObjectFactory().wrap(e.getValue());
				}
			}
		}
		return null;
	}

	@Override
	public void setExtensionElements(ExtensionElements value){
		int index = -1;
		for(int i=0; i<getModelObject().getContent().size(); i++){
			Serializable s = getModelObject().getContent().get(i);
			if(s instanceof JAXBElement<?>){
				JAXBElement<?> e = (JAXBElement<?>) s;
				if(e.getValue() instanceof EJaxbTExtensionElements){
					index = i;
					break;
				}
			}
		}
		
		JAXBElement<EJaxbTExtensionElements> e = 
			new JAXBElement<EJaxbTExtensionElements>(ExtensionElements.QNAME, EJaxbTExtensionElements.class, ((ExtensionElementsImpl)value).getModelObject());
		if(index==-1){
			getModelObject().getContent().add(e);
		}
		else{
			getModelObject().getContent().set(index, e);
		}
	}

	@Override
	public boolean hasExtensionElements(){
		for(Serializable s : getModelObject().getContent()){
			if(s instanceof JAXBElement<?>){
				JAXBElement<?> e = (JAXBElement<?>) s;
				if(e.getValue() instanceof EJaxbTExtensionElements){
					return true;
				}
			}
		}
		return false;
	}
}
