/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Artifact;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ConversationAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ConversationLink;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ConversationNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CorrelationKey;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageFlowAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ParticipantAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TCollaboration;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTArtifact;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCollaboration;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTConversationAssociation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTConversationLink;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCorrelationKey;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTMessageFlow;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTMessageFlowAssociation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTParticipant;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTParticipantAssociation;

class TCollaborationImpl extends AbstractTRootElementImpl<EJaxbTCollaboration>
implements TCollaboration {

    protected TCollaborationImpl(XmlContext xmlContext,
            EJaxbTCollaboration jaxbModel) {
        super(xmlContext, jaxbModel);

    }

    public Participant getParticipant(String id){
        
        Participant[] participants = getParticipant();
        for(Participant p : participants){
            if(p.getId().equals(id)){
                return p;
            }
        }
        return null;
    }

    @Override
    public Participant[] getParticipant() {
        return createChildrenArray(getModelObject().getParticipant(),
                EJaxbTParticipant.class, ANY_QNAME, ParticipantImpl.class);
    }

    @Override
    public boolean hasParticipant() {
        return this.getModelObject().isSetParticipant();
    }

    @Override
    public void unsetParticipant() {
        this.getModelObject().unsetParticipant();

    }

    @Override
    public void addParticipant(Participant p) {
        addToChildren(this.getModelObject().getParticipant(), p);
    }

    @Override
    public void removeParticipant(Participant p) {
        removeFromChildren(this.getModelObject().getParticipant(), p);
    }

    @Override
    public MessageFlow[] getMessageFlow() {
        return createChildrenArray(getModelObject().getMessageFlow(),
                EJaxbTMessageFlow.class, ANY_QNAME, MessageFlowImpl.class);
    }

    @Override
    public boolean hasMessageFlow() {
        return this.getModelObject().isSetMessageFlow();
    }

    @Override
    public void unsetMessageFlow() {
        this.getModelObject().unsetMessageFlow();
    }

    @Override
    public void addMessageFlow(MessageFlow mf) {
        addToChildren(getModelObject().getMessageFlow(), mf);
    }

    @Override
    public void removeMessageFlow(MessageFlow mf) {
        removeFromChildren(getModelObject().getMessageFlow(), mf);
    }

    @Override
    public Artifact[] getArtifact() {
        XmlObject[] t = createChildrenArray(getModelObject().getArtifact(), EJaxbTArtifact.class, ANY_QNAME);
        Artifact[] result = new Artifact[t.length];
        for(int i=0; i<t.length; i++){
            result[i] = (Artifact) t[i];
        }
        return result;
    }

    @Override
    public void addArtifact(Artifact a){
        addToChildren(getModelObject().getArtifact(), a);
    }

    @Override
    public void removeArtifact(Artifact a){
        removeFromChildren(getModelObject().getArtifact(), a);
    }

    @Override
    public boolean hasArtifact() {
        return this.getModelObject().isSetArtifact();
    }

    @Override
    public void unsetArtifact() {
        this.getModelObject().unsetArtifact();
    }

    @Override
    public ConversationNode[] getConversationNode() {
        ConversationNode[] result = new ConversationNode[getModelObject().getConversationNode().size()];
        for(int i=0; i<result.length; i++){
            result[i] = (ConversationNode)this.getXmlContext().getXmlObjectFactory()
                    .wrap(getModelObject().getConversationNode().get(i).getValue());
        }
        return result;
    }

    @Override
    public boolean hasConversationNode() {
        return this.getModelObject().isSetConversationNode();
    }

    @Override
    public void unsetConversationNode() {
        this.getModelObject().unsetConversationNode();
    }

    @Override
    public ConversationAssociation[] getConversationAssociation() {
        return createChildrenArray(getModelObject()
                .getConversationAssociation(),
                EJaxbTConversationAssociation.class, ANY_QNAME,
                ConversationAssociationImpl.class);
    }

    @Override
    public boolean hasConversationAssociation() {
        return this.getModelObject().isSetConversationAssociation();
    }

    @Override
    public void unsetConversationAssociation() {
        this.getModelObject().unsetConversationAssociation();
    }

    @Override
    public ParticipantAssociation[] getParticipantAssociation() {
        return createChildrenArray(
                getModelObject().getParticipantAssociation(),
                EJaxbTParticipantAssociation.class, ANY_QNAME,
                ParticipantAssociationImpl.class);
    }

    @Override
    public boolean hasParticipantAssociation() {
        return this.getModelObject().isSetConversationAssociation();
    }

    @Override
    public void unsetParticipantAssociation() {
        this.getModelObject().unsetParticipantAssociation();
    }

    @Override
    public MessageFlowAssociation[] getMessageFlowAssociation() {
        return createChildrenArray(
                getModelObject().getMessageFlowAssociation(),
                EJaxbTMessageFlowAssociation.class, ANY_QNAME,
                MessageFlowAssociationImpl.class);
    }

    @Override
    public boolean hasMessageFlowAssociation() {
        return this.getModelObject().isSetMessageFlowAssociation();
    }

    @Override
    public void unsetMessageFlowAssociation() {
        this.getModelObject().unsetMessageFlow();
    }

    @Override
    public CorrelationKey[] getCorrelationKey() {
        return createChildrenArray(getModelObject().getCorrelationKey(),
                EJaxbTCorrelationKey.class, ANY_QNAME, CorrelationKeyImpl.class);
    }

    @Override
    public boolean hasCorrelationKey() {
        return this.getModelObject().isSetCorrelationKey();
    }

    @Override
    public void unsetCorrelationKey() {
        this.getModelObject().unsetCorrelationKey();
    }

    @Override
    public QName[] getChoreographyRef() {
        List<QName> l = this.getModelObject().getChoreographyRef();
        return l.toArray(new QName[l.size()]);
    }

    @Override
    public boolean hasChoreographyRef() {
        return this.getModelObject().isSetChoreographyRef();
    }

    @Override
    public void unsetChoreographyRef() {
        this.getModelObject().unsetChoreographyRef();
    }

    @Override
    public void addChoreographyRef(QName ref){
        this.getModelObject().getChoreographyRef().add(ref);
    }

    @Override
    public void removeChoreographyRef(QName ref){
        this.getModelObject().getChoreographyRef().remove(ref);
    }

    @Override
    public ConversationLink[] getConversationLink() {
        return createChildrenArray(getModelObject().getConversationLink(),
                EJaxbTConversationLink.class, ANY_QNAME, ConversationLinkImpl.class);
    }

    @Override
    public boolean hasConversationLink() {
        return this.getModelObject().isSetConversationLink();
    }

    @Override
    public void unsetConversationLink() {
        this.getModelObject().unsetConversationLink();
    }

    @Override
    public String getName() {
        return this.getModelObject().getName();
    }

    @Override
    public void setName(String value) {
        this.getModelObject().setName(value);
    }

    @Override
    public boolean hasName() {
        return this.getModelObject().isSetName();
    }

    @Override
    public boolean isIsClosed() {
        return this.getModelObject().isIsClosed();
    }

    @Override
    public void setIsClosed(boolean value) {
        this.getModelObject().setIsClosed(value);
    }

    @Override
    public boolean hasIsClosed() {
        return this.getModelObject().isIsClosed();
    }

    @Override
    public void unsetIsClosed() {
        this.getModelObject().unsetIsClosed();
    }

    @Override
    protected Class<? extends EJaxbTCollaboration> getCompliantModelClass() {
        return EJaxbTCollaboration.class;
    }


}
