/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CorrelationPropertyRetrievalExpression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TCorrelationProperty;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCorrelationProperty;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCorrelationPropertyRetrievalExpression;

class TCorrelationPropertyImpl extends
		AbstractTRootElementImpl<EJaxbTCorrelationProperty> implements
		TCorrelationProperty {

	protected TCorrelationPropertyImpl(XmlContext xmlContext,
			EJaxbTCorrelationProperty jaxbModel) {
		super(xmlContext, jaxbModel);

	}

	@Override
	public CorrelationPropertyRetrievalExpression[] getCorrelationPropertyRetrievalExpression() {
		return createChildrenArray(getModelObject()
				.getCorrelationPropertyRetrievalExpression(),
				EJaxbTCorrelationPropertyRetrievalExpression.class, ANY_QNAME,
				CorrelationPropertyRetrievalExpressionImpl.class);
	}

	@Override
	public boolean hasCorrelationPropertyRetrievalExpression() {
		return this.getModelObject()
				.isSetCorrelationPropertyRetrievalExpression();
	}

	@Override
	public void unsetCorrelationPropertyRetrievalExpression() {
		this.getModelObject().unsetCorrelationPropertyRetrievalExpression();
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
	public QName getType() {
		return this.getModelObject().getType();
	}

	@Override
	public void setType(QName value) {
		this.getModelObject().setType(value);
	}

	@Override
	public boolean hasType() {
		return this.getModelObject().isSetType();
	}

	@Override
	protected Class<? extends EJaxbTCorrelationProperty> getCompliantModelClass() {
		return EJaxbTCorrelationProperty.class;
	}

}
