/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TEventBasedGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TEventBasedGatewayType;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTEventBasedGateway;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTEventBasedGatewayType;

class TEventBasedGatewayImpl extends
		AbstractTGatewayImpl<EJaxbTEventBasedGateway> implements
		TEventBasedGateway {

	protected TEventBasedGatewayImpl(XmlContext xmlContext,
			EJaxbTEventBasedGateway jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	public boolean isInstantiate() {
		return this.getModelObject().isInstantiate();
	}

	@Override
	public void setInstantiate(boolean value) {
		this.getModelObject().setInstantiate(value);
	}

	@Override
	public boolean hasInstantiate() {
		return this.getModelObject().isInstantiate();
	}

	@Override
	public void unsetInstantiate() {
		this.getModelObject().unsetInstantiate();
	}

	@Override
	public TEventBasedGatewayType getEventGatewayType() {
		if (getModelObject().getEventGatewayType() == null){
			return null;
		}
		TEventBasedGatewayType result = null;
		switch(getModelObject().getEventGatewayType()){
		case EXCLUSIVE:
			result = TEventBasedGatewayType.Exclusive;
			break;
		case PARALLEL:
			result = TEventBasedGatewayType.Parallel;
			break;
		}
		return result;
	}

	@Override
	public void setEventGatewayType(TEventBasedGatewayType value) {
		if (value == null) {
			getModelObject().setEventGatewayType(null);
		} else if (value.equals(TEventBasedGatewayType.Exclusive)) {
			getModelObject().setEventGatewayType(
					EJaxbTEventBasedGatewayType.EXCLUSIVE);
		} else if (value.equals(TEventBasedGatewayType.Parallel)) {
			getModelObject().setEventGatewayType(
					EJaxbTEventBasedGatewayType.PARALLEL);
		}
	}

	@Override
	public boolean hasEventGatewayType() {
		return this.getModelObject().isSetEventGatewayType();
	}

	@Override
	protected Class<? extends EJaxbTEventBasedGateway> getCompliantModelClass() {
		return EJaxbTEventBasedGateway.class;
	}

}
