/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.ImportType;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TImport;
import com.ebmwebsourcing.easyschema10.api.element.Schema;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTImport;

class TImportImpl extends AbstractJaxbXmlObjectImpl<EJaxbTImport> implements
		TImport {

    private XmlObject content;
    
	protected TImportImpl(XmlContext xmlContext, EJaxbTImport jaxbModel) {
		super(xmlContext, jaxbModel);
		content = null;
	}

	@Override
	public String getNamespace() {
		return this.getModelObject().getNamespace();
	}

	@Override
	public void setNamespace(String value) {
		this.getModelObject().setNamespace(value);
	}

	@Override
	public boolean hasNamespace() {
		return this.getModelObject().isSetNamespace();
	}

	@Override
	public String getLocation() {
		return this.getModelObject().getLocation();
	}

	@Override
	public void setLocation(String value) {
		this.getModelObject().setLocation(value);
	}

	@Override
	public boolean hasLocation() {
		return this.getModelObject().isSetLocation();
	}

	@Override
	public String getImportType() {
		return this.getModelObject().getImportType();
	}

	@Override
	public void setImportType(String value) {
		this.getModelObject().setImportType(value);
	}

	@Override
	public boolean hasImportType() {
		return this.getModelObject().isSetImportType();
	}

	@Override
	protected Class<? extends EJaxbTImport> getCompliantModelClass() {
		return EJaxbTImport.class;
	}

	@Override
	public boolean isBPMN20Import() {
		ImportType it = ImportType.fromValue(this.getModelObject().getImportType());
		return (it!=null && it.equals(ImportType.BPMN20)); 
	}

	@Override
	public boolean isWSDL20Import() {
		ImportType it = ImportType.fromValue(this.getModelObject().getImportType());
		return (it!=null && it.equals(ImportType.WSDL20)); 
	}
	
	@Override
	public boolean isWSDL11Import() {
		ImportType it = ImportType.fromValue(this.getModelObject().getImportType());
		return (it!=null && it.equals(ImportType.WSDL11)); 
	}

	@Override
	public boolean isXSDImport() {
		ImportType it = ImportType.fromValue(this.getModelObject().getImportType());
		return (it!=null && it.equals(ImportType.XSD)); 
	}
	
	@Override
	public com.ebmwebsourcing.easywsdl11.api.element.Definitions getWSDL11Definitions() {
	    return (com.ebmwebsourcing.easywsdl11.api.element.Definitions) getXmlObjectAdoptedChildren()[0];
	}
	
	@Override
	public Definitions getBPMNDefinitions() {
	    return (Definitions) getXmlObjectAdoptedChildren()[0];
	}
	
	@Override
	public Schema getSchema() {
	    return (Schema) getXmlObjectAdoptedChildren()[0];
	}
	
	@Override
	public XmlObject getImportContent() {
	    return getXmlObjectAdoptedChildren()[0];
	}
	
	@Override
    public void setImportContent(XmlObject content) {
        this.content = content; 
    }
	
	@Override
    public final XmlObject[] getXmlObjectAdoptedChildren() {
        if (content == null) { 
        	content = adoptChild(getNamespace(), getLocation(), 0);
        }
        return new XmlObject[] { content };
    }

}
