/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TInterface;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTInterface;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTOperation;

class TInterfaceImpl extends AbstractTRootElementImpl<EJaxbTInterface>
		implements TInterface {

	protected TInterfaceImpl(XmlContext xmlContext, EJaxbTInterface jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public Operation[] getOperations() {
		return createChildrenArray(getModelObject().getOperation(),
				EJaxbTOperation.class, ANY_QNAME, OperationImpl.class);
	}
	
	@Override
	public Operation getOperation(String opName) {
	    for(EJaxbTOperation opModelObject : getModelObject().getOperation()) {
	        if(opModelObject.isSetName() && opModelObject.getName().equals(opName)) {
	            return (Operation) getXmlContext().getXmlObjectFactory().wrap(opModelObject);
	        }
	    }
	    return null;
	}

	@Override
	public boolean hasOperation() {
		return this.getModelObject().isSetOperation();
	}

	@Override
	public void unsetOperation() {
		this.getModelObject().unsetOperation();

	}
	
	@Override
	public void addOperation(Operation o){
	    addToChildren(getModelObject().getOperation(), o);
	}
	  
	@Override
	public void removeOperation(Operation o){
		removeFromChildren(getModelObject().getOperation(), o);
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
	public QName getImplementationRef() {
		return this.getModelObject().getImplementationRef();
	}

	@Override
	public void setImplementationRef(QName value) {
		this.getModelObject().setImplementationRef(value);

	}

	@Override
	public boolean hasImplementationRef() {
		return this.getModelObject().isSetImplementationRef();
	}

	@Override
	protected Class<? extends EJaxbTInterface> getCompliantModelClass() {
		return EJaxbTInterface.class;
	}

}
