/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TParticipantMultiplicity;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTParticipantMultiplicity;

public class TParticipantMultiplicityImpl extends
		AbstractTBaseElementImpl<EJaxbTParticipantMultiplicity> implements
		TParticipantMultiplicity {

	protected TParticipantMultiplicityImpl(XmlContext xmlContext,
			EJaxbTParticipantMultiplicity jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	public int getMinimum() {
		return this.getModelObject().getMinimum();
	}

	@Override
	public void setMinimum(int value) {
		this.getModelObject().setMinimum(value);
	}

	@Override
	public boolean hasMinimum() {
		return this.getModelObject().isSetMinimum();
	}

	@Override
	public void unsetMinimum() {
		this.getModelObject().unsetMinimum();
	}

	@Override
	public int getMaximum() {
		return this.getModelObject().getMaximum();
	}

	@Override
	public void setMaximum(int value) {
		this.getModelObject().setMaximum(value);
	}

	@Override
	public boolean hasMaximum() {
		return this.getModelObject().isSetMaximum();
	}

	@Override
	public void unsetMaximum() {
		this.getModelObject().unsetMaximum();
	}

	@Override
	protected Class<? extends EJaxbTParticipantMultiplicity> getCompliantModelClass() {
		return EJaxbTParticipantMultiplicity.class;
	}
}
