/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/

package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Artifact;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Auditing;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CorrelationSubscription;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.LaneSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Monitoring;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Property;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ResourceRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TProcess;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TProcessType;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTArtifact;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCorrelationSubscription;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFlowElement;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFlowNode;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTLaneSet;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTProcess;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTProcessType;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTProperty;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTResourceRole;

class TProcessImpl extends TCallableElementImpl implements TProcess {

    protected TProcessImpl(XmlContext xmlContext, EJaxbTProcess jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public EJaxbTProcess getModelObject() {
        return (EJaxbTProcess) super.getModelObject();
    }

    @Override
    public Auditing getAuditing() {
        if (this.getModelObject().getAuditing() == null) {
            return null;
        }
        return this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getAuditing(),
                AuditingImpl.class);
    }

    @Override
    public void setAuditing(Auditing value) {
        if (value != null) {
            this.getModelObject().setAuditing(((AuditingImpl) value).getModelObject());
        } else {
            this.getModelObject().setAuditing(null);
        }
    }

    @Override
    public boolean hasAuditing() {
        return this.getModelObject().isSetAuditing();
    }

    @Override
    public Monitoring getMonitoring() {
        if (this.getModelObject().getMonitoring() == null) {
            return null;
        }
        return this.getXmlContext().getXmlObjectFactory().wrap(
                this.getModelObject().getMonitoring(), MonitoringImpl.class);
    }

    @Override
    public void setMonitoring(Monitoring value) {
        if (value != null) {
            this.getModelObject().setMonitoring(((MonitoringImpl) value).getModelObject());
        } else {
            this.getModelObject().setMonitoring(null);
        }
    }

    @Override
    public boolean hasMonitoring() {
        return this.getModelObject().isSetMonitoring();
    }

    @Override
    public Property[] getProperty() {
        return createChildrenArray(getModelObject().getProperty(), EJaxbTProperty.class, ANY_QNAME,
                PropertyImpl.class);
    }

    @Override
    public boolean hasProperty() {
        return this.getModelObject().isSetProperty();
    }

    @Override
    public void unsetProperty() {
        this.getModelObject().unsetProperty();
    }

    @Override
    public void addProperty(Property p) {
        this.getModelObject().getProperty().add(((PropertyImpl) p).getModelObject());
    }

    @Override
    public void removeProperty(Property p) {
        this.getModelObject().getProperty().remove(((PropertyImpl) p).getModelObject());
    }

    @Override
    public LaneSet[] getLaneSets() {
        return createChildrenArray(getModelObject().getLaneSet(), EJaxbTLaneSet.class, ANY_QNAME,
                LaneSetImpl.class);
    }

    @Override
    public boolean hasLaneSet() {
        return this.getModelObject().isSetLaneSet();
    }

    @Override
    public void unsetLaneSet() {
        this.getModelObject().unsetLaneSet();
    }

    @Override
    public void addLaneSet(LaneSet ls) {
        addToChildren(getModelObject().getLaneSet(), ls);
    }

    @Override
    public void removeLaneSet(LaneSet ls) {
        removeFromChildren(getModelObject().getLaneSet(), ls);
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T extends FlowElement> List<T> getFlowElementsByClass(Class<T> c) {
        List<T> l = new ArrayList<T>();
        for (FlowElement fe : getFlowElement()) {
            if (c.isAssignableFrom(fe.getClass())) {
                l.add((T) fe);
            }
        }
        return l;
    }

    @Override
    public FlowNode[] getFlowNode() {
        XmlObject[] tab = createChildrenArray(getModelObject().getFlowElement(),
                EJaxbTFlowNode.class, ANY_QNAME);
        FlowNode[] result = new FlowNode[tab.length];
        for (int i = 0; i < tab.length; i++) {
            result[i] = (FlowNode) tab[i];
        }
        return result;
    }

    @Override
    public FlowElement[] getFlowElement() {
        XmlObject[] tab = createChildrenArray(getModelObject().getFlowElement(),
                EJaxbTFlowElement.class, ANY_QNAME);
        FlowElement[] result = new FlowElement[tab.length];
        for (int i = 0; i < tab.length; i++) {
            result[i] = (FlowElement) tab[i];
        }
        return result;
    }

    @Override
    public FlowElement getFlowElementById(String id) {
        for (FlowElement fe : getFlowElement()) {
            if (fe.getId().equals(id)) {
                return fe;
            }
        }
        return null;
    }

    @Override
    public boolean hasFlowElement() {
        return this.getModelObject().isSetFlowElement();
    }

    @Override
    public void unsetFlowElement() {
        this.getModelObject().unsetFlowElement();
    }

    @Override
    public void addFlowElement(FlowElement fe) {
        addToChildren(this.getModelObject().getFlowElement(), fe);
    }

    @Override
    public void removeFlowElement(FlowElement fe) {
        removeFromChildren(this.getModelObject().getFlowElement(), fe);
    }

    @Override
    public Artifact[] getArtifact() {
        XmlObject[] t = createChildrenArray(getModelObject().getArtifact(), EJaxbTArtifact.class,
                ANY_QNAME);
        Artifact[] result = new Artifact[t.length];
        for (int i = 0; i < t.length; i++) {
            result[i] = (Artifact) t[i];
        }
        return result;
    }

    @Override
    public void addArtifact(Artifact a) {
        addToChildren(getModelObject().getArtifact(), a);
    }

    @Override
    public void removeArtifact(Artifact a) {
        removeFromChildren(getModelObject().getArtifact(), a);
    }

    @Override
    public boolean hasArtifact() {
        return this.getModelObject().isSetArtifact();
    }

    @Override
    public void unsetArtifact() {
        this.getModelObject().unsetArtifact();
    }

    @Override
    public ResourceRole[] getResourceRole() {
        return createChildrenArray(getModelObject().getResourceRole(), EJaxbTResourceRole.class,
                ANY_QNAME, ResourceRoleImpl.class);
    }

    @Override
    public boolean hasResourceRole() {
        return this.getModelObject().isSetResourceRole();
    }

    @Override
    public void unsetResourceRole() {
        this.getModelObject().unsetResourceRole();
    }

    @Override
    public CorrelationSubscription[] getCorrelationSubscription() {
        return createChildrenArray(getModelObject().getCorrelationSubscription(),
                EJaxbTCorrelationSubscription.class, ANY_QNAME, CorrelationSubscriptionImpl.class);
    }

    @Override
    public boolean hasCorrelationSubscription() {
        return this.getModelObject().isSetCorrelationSubscription();
    }

    @Override
    public void unsetCorrelationSubscription() {
        this.getModelObject().unsetCorrelationSubscription();
    }

    @Override
    public QName[] getSupports() {
        List<QName> l = this.getModelObject().getSupports();
        return l.toArray(new QName[l.size()]);
    }

    @Override
    public boolean hasSupports() {
        return this.getModelObject().isSetSupports();
    }

    @Override
    public void unsetSupports() {
        this.getModelObject().unsetSupports();
    }

    @Override
    public void addSupport(QName support) {
        this.getModelObject().getSupports().add(support);
    }

    @Override
    public void removeSupport(QName support) {
        this.getModelObject().getSupports().remove(support);
    }

    public TProcessType getProcessType() {
        if (getModelObject().getProcessType() == null) {
            return null;
        }
        TProcessType result = null;
        switch (getModelObject().getProcessType()) {
            case NONE:
                result = TProcessType.None;
                break;
            case PRIVATE:
                result = TProcessType.Private;
                break;
            case PUBLIC:
                result = TProcessType.Public;
                break;
        }
        return result;
    }

    @Override
    public void setProcessType(TProcessType value) {

        if (value == null) {
            this.getModelObject().setProcessType(null);
        } else if (value.equals(TProcessType.None)) {
            getModelObject().setProcessType(EJaxbTProcessType.NONE);
        } else if (value.equals(TProcessType.Private)) {
            getModelObject().setProcessType(EJaxbTProcessType.PRIVATE);
        } else if (value.equals(TProcessType.Public)) {
            getModelObject().setProcessType(EJaxbTProcessType.PUBLIC);
        }
    }

    @Override
    public boolean hasProcessType() {
        return this.getModelObject().isSetProcessType();
    }

    @Override
    public boolean isIsClosed() {
        return this.getModelObject().isIsClosed();
    }

    @Override
    public void setIsClosed(boolean value) {
        this.getModelObject().setIsClosed(value);
    }

    @Override
    public boolean hasIsClosed() {
        return this.getModelObject().isSetIsClosed();
    }

    @Override
    public void unsetIsClosed() {
        this.getModelObject().unsetIsClosed();
    }

    @Override
    public boolean isIsExecutable() {
        if (hasIsExecutable()) {
            return this.getModelObject().isIsExecutable();
        } else {
            return false;
        }
    }

    @Override
    public void setIsExecutable(boolean value) {
        this.getModelObject().setIsExecutable(value);
    }

    @Override
    public boolean hasIsExecutable() {
        return this.getModelObject().isSetIsExecutable();
    }

    @Override
    public void unsetIsExecutable() {
        this.getModelObject().unsetIsExecutable();
    }

    @Override
    public QName getDefinitionalCollaborationRef() {
        return this.getModelObject().getDefinitionalCollaborationRef();
    }

    @Override
    public void setDefinitionalCollaborationRef(QName value) {
        this.getModelObject().setDefinitionalCollaborationRef(value);
    }

    @Override
    public boolean hasDefinitionalCollaborationRef() {
        return this.getModelObject().isSetDefinitionalCollaborationRef();
    }

    @Override
    protected Class<? extends EJaxbTProcess> getCompliantModelClass() {
        return EJaxbTProcess.class;
    }

}
